/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.config;

import mods.defeatedcrow.common.config.DCsConfig;

public class PropertyHandler {
    private static DustDifficulty currentDustDef = DustDifficulty.NORMAL;
    private static ChargeDifficulty currentChargeDef = ChargeDifficulty.NORMAL;
    private static ConversionRate currentConversionRate = ConversionRate.NORMAL;

    private PropertyHandler() {
    }

    public static void loadConfig() {
        currentDustDef = DustDifficulty.getDifficulty(DCsConfig.dustDif);
        currentChargeDef = ChargeDifficulty.getDifficulty(DCsConfig.chargeDif);
        currentConversionRate = ConversionRate.getRate(DCsConfig.exchangeDif);
    }

    public static int[] getDustGen() {
        return new int[]{PropertyHandler.currentDustDef.mainProductNum, PropertyHandler.currentDustDef.subProductNum};
    }

    public static int ChargeGenRate() {
        return PropertyHandler.currentChargeDef.rate;
    }

    public static int rateRF() {
        return PropertyHandler.currentConversionRate.rate_RF;
    }

    public static int rateGF() {
        return PropertyHandler.currentConversionRate.rate_GF;
    }

    public static int rateEU() {
        return PropertyHandler.currentConversionRate.rate_EU;
    }

    public static enum ConversionRate {
        NO_CHANGE(1, 1, 1),
        WEAKER_CHARGE(5, 2, 1),
        NORMAL(10, 3, 2),
        HIGH_CHARGE(20, 6, 4),
        HARDER_CHARGE(100, 30, 20);

        public final int rate_RF;
        public final int rate_GF;
        public final int rate_EU;
        public static final ConversionRate[] DIFFICULTY;

        private ConversionRate(int rf, int gf, int eu) {
            this.rate_RF = rf;
            this.rate_GF = gf;
            this.rate_EU = eu;
        }

        public static ConversionRate getRate(int id) {
            int i = id;
            if (i < 0 || i > DIFFICULTY.length) {
                i = 2;
            }
            return DIFFICULTY[i];
        }

        static {
            DIFFICULTY = new ConversionRate[]{NO_CHANGE, WEAKER_CHARGE, NORMAL, HIGH_CHARGE, HARDER_CHARGE};
        }
    }

    public static enum ChargeDifficulty {
        SWEET(800),
        NORMAL(400),
        BITTER(200),
        HARD(40);

        public final int rate;
        public static final ChargeDifficulty[] DIFFICULTY;

        private ChargeDifficulty(int rate) {
            this.rate = rate;
        }

        public static ChargeDifficulty getDifficulty(int id) {
            int i = id;
            if (i < 0 || i > DIFFICULTY.length) {
                i = 1;
            }
            return DIFFICULTY[i];
        }

        static {
            DIFFICULTY = new ChargeDifficulty[]{SWEET, NORMAL, BITTER, HARD};
        }
    }

    public static enum DustDifficulty {
        SWEET(3, 1),
        NORMAL(2, 1),
        BITTER(1, 0),
        HARD(0, 1);

        public final int mainProductNum;
        public final int subProductNum;
        public static final DustDifficulty[] DIFFICULTY;

        private DustDifficulty(int main, int sub) {
            this.mainProductNum = main;
            this.subProductNum = sub;
        }

        public static DustDifficulty getDifficulty(int id) {
            int i = id;
            if (i < 0 || i > DIFFICULTY.length) {
                i = 1;
            }
            return DIFFICULTY[i];
        }

        static {
            DIFFICULTY = new DustDifficulty[]{SWEET, NORMAL, BITTER, HARD};
        }
    }
}

