/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.block.plants;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.defeatedcrow.api.plants.IRightClickHarvestable;
import mods.defeatedcrow.api.plants.PlantsClickEvent;
import mods.defeatedcrow.common.AchievementRegister;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.handler.Util;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;

public class BlockTeaTree
extends Block
implements IShearable,
IPlantable,
IRightClickHarvestable {
    @SideOnly(value=Side.CLIENT)
    private IIcon leafIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon newleafIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon logIcon;

    public BlockTeaTree() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        this.func_149711_c(0.1f);
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        int meta;
        if (!par1World.field_72995_K && par1World.field_73012_v.nextInt(6) == 0 && (meta = par1World.func_72805_g(par2, par3, par4)) != 1 && par1World.func_72957_l(par2, par3, par4) > 11) {
            par1World.func_72921_c(par2, par3, par4, 1, 3);
        }
    }

    public boolean fertilize(World par1World, int par2, int par3, int par4) {
        return par1World.func_72921_c(par2, par3, par4, 1, 2);
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        ItemStack currentItem;
        ItemStack itemstack = par5EntityPlayer.field_71071_by.func_70448_g();
        Block block = par1World.func_147439_a(par2, par3, par4);
        int meta = par1World.func_72805_g(par2, par3, par4);
        PlantsClickEvent event = new PlantsClickEvent(par1World, par5EntityPlayer, itemstack, block, this, meta, par2, par3, par4);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.hasResult() && event.getResult() == Event.Result.ALLOW) {
            par1World.func_72956_a((Entity)par5EntityPlayer, "random.pop", 0.4f, 1.8f);
            return true;
        }
        if (event.isCanceled()) {
            return false;
        }
        InventoryPlayer inventory = par5EntityPlayer.field_71071_by;
        if (inventory != null && this.onHarvest(par1World, par2, par3, par4, (IInventory)inventory, currentItem = inventory.func_70448_g())) {
            par5EntityPlayer.func_71029_a((StatBase)AchievementRegister.getTeaLeaves);
            par1World.func_72956_a((Entity)par5EntityPlayer, "random.pop", 0.4f, 1.8f);
            return true;
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return DCsAppleMilk.modelTeaTree;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        int i = par2;
        if (par1 == 0) {
            return this.logIcon;
        }
        if (par1 == 1) {
            return this.leafIcon;
        }
        return this.newleafIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return Item.func_150898_a((Block)DCsAppleMilk.saplingTea);
    }

    public int func_149745_a(Random random) {
        return random.nextInt(2) == 0 ? 1 : 2;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int chance = this.getChance(metadata);
        ItemStack crop = this.getCropItem(metadata);
        ret.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), this.func_149745_a(world.field_73012_v), this.func_149692_a(metadata)));
        if (fortune > 0 && (chance -= 10 << fortune) < 2) {
            chance = 2;
        }
        if (crop != null) {
            ret.add(crop);
            if (world.field_73012_v.nextInt(chance) == 0) {
                ret.add(crop);
            }
        }
        return ret;
    }

    protected int getChance(int meta) {
        return meta == 3 ? 2 : 10;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.leafIcon = par1IconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealeaf");
        this.newleafIcon = par1IconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealeaf_2");
        this.logIcon = par1IconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealog");
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean onHarvest(World world, int x, int y, int z, IInventory inventory, ItemStack currentItem) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 1) {
            return false;
        }
        ItemStack ret = this.getCropItem(meta);
        boolean flag = false;
        if (Util.notEmptyItem(ret) && (currentItem == null || currentItem.func_77973_b() == ret.func_77973_b())) {
            if (inventory instanceof InventoryPlayer) {
                InventoryPlayer playerInv = (InventoryPlayer)inventory;
                if (playerInv.func_70441_a(ret)) {
                    world.func_72921_c(x, y, z, 0, 3);
                    playerInv.func_70296_d();
                    return true;
                }
                flag = true;
            } else if (inventory != null) {
                int slot = this.getAddSlot(inventory, ret);
                if (slot > -1) {
                    if (inventory.func_70301_a(slot) == null) {
                        inventory.func_70299_a(slot, ret);
                    } else {
                        ++inventory.func_70301_a((int)slot).field_77994_a;
                    }
                    world.func_72921_c(x, y, z, 0, 3);
                    return true;
                }
                flag = true;
            } else {
                flag = true;
            }
        }
        if (flag) {
            float a = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float a1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float a2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem drop = new EntityItem(world, (double)((float)x + a), (double)((float)y + 1.0f + a1), (double)((float)z + a2), ret);
            drop.field_70181_x = 0.25;
            if (!world.field_72995_K && world.func_72838_d((Entity)drop)) {
                world.func_72921_c(x, y, z, 0, 3);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isHarvestable(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 1;
    }

    @Override
    public ItemStack getCropItem(int blockMeta) {
        ItemStack ret = null;
        if (blockMeta == 1) {
            ret = new ItemStack(DCsAppleMilk.leafTea, 1, 0);
        }
        return ret;
    }

    private int getAddSlot(IInventory inventory, ItemStack get) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) {
                return i;
            }
            if (!Util.notEmptyItem(get)) continue;
            ItemStack cur = inventory.func_70301_a(i);
            if (get.func_77973_b() != cur.func_77973_b() || get.func_77960_j() != cur.func_77960_j() || cur.field_77994_a >= cur.func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGrownMetadata(World world, int x, int y, int z) {
        return 1;
    }

    @Override
    public int getInitialMetadata(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getGrownMetadata(int meta) {
        return 1;
    }

    @Override
    public int getInitialMetadata(int meta) {
        return 0;
    }

    @Override
    public Block getSaplingBlock(int meta) {
        return DCsAppleMilk.saplingTea;
    }

    @Override
    public int getSaplingMeta(int meta) {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }
}

