/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common;

import cpw.mods.fml.common.event.FMLInterModComms;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReceivingIMCEvent {
    private ReceivingIMCEvent() {
    }

    public static void receiveIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equals("TeaMakerRecipe")) {
                ReceivingIMCEvent.receiveAddTeaRecipe(event, message);
                continue;
            }
            if (message.key.equals("IceMakerRecipe")) {
                ReceivingIMCEvent.receiveAddIceRecipe(event, message);
                continue;
            }
            if (message.key.equals("IceChargeItem")) {
                ReceivingIMCEvent.receiveAddIceCharge(event, message);
                continue;
            }
            AMTLogger.warn("Received IMC message with unknown key : " + message.key);
        }
    }

    private static void receiveAddTeaRecipe(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag;
        boolean flag = false;
        if (message.isNBTMessage() && (tag = message.getNBTValue()).func_150297_b("input", 10) && tag.func_150297_b("output", 10) && tag.func_74764_b("texture")) {
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("input"));
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("output"));
            ItemStack outputMilk = null;
            if (tag.func_150297_b("outputMilk", 10)) {
                outputMilk = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("outputMilk"));
            }
            String texture = tag.func_74779_i("texture");
            String texture_milk = "defeatedcrow:textures/blocks/contents_water.png";
            if (tag.func_74764_b("textureMilk")) {
                texture_milk = tag.func_74779_i("textureMilk");
            }
            if (input != null && output != null && texture != null) {
                RecipeRegisterManager.teaRecipe.registerCanMilk(input, output, outputMilk, texture, texture_milk);
                flag = true;
            }
        }
        if (!flag) {
            AMTLogger.warn("Failed to register new TeaMaker recipe with IMCMassage from " + message.getSender());
        }
    }

    private static void receiveAddIceRecipe(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag;
        boolean flag = false;
        if (message.isNBTMessage() && (tag = message.getNBTValue()).func_150297_b("input", 10) && tag.func_150297_b("output", 10)) {
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("input"));
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("output"));
            ItemStack container = null;
            if (tag.func_150297_b("container", 10)) {
                container = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("container"));
            }
            if (input != null && output != null) {
                RecipeRegisterManager.iceRecipe.registerCanLeave(input, output, container);
                flag = true;
            }
        }
        if (!flag) {
            AMTLogger.warn("Failed to register new IceMaker recipe with IMCMassage from " + message.getSender());
        }
    }

    private static void receiveAddIceCharge(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag;
        boolean flag = false;
        if (message.isNBTMessage() && (tag = message.getNBTValue()).func_150297_b("input", 10) && tag.func_74764_b("amount")) {
            ItemStack input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("input"));
            int amount = 0;
            amount = tag.func_74762_e("amount");
            if (input != null && amount > 0) {
                RecipeRegisterManager.iceRecipe.registerCharger(input, amount);
                flag = true;
            }
        }
        if (!flag) {
            AMTLogger.warn("Failed to register new IceMaker chageable item with IMCMassage from " + message.getSender());
        }
    }
}

