/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.asm.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mods.defeatedcrow.asm.config.DCsConfiguration;
import mods.defeatedcrow.asm.config.PropertyDC;

public class ConfigCategoryDC
implements Map<String, PropertyDC> {
    private String name;
    private String comment;
    private ArrayList<ConfigCategoryDC> children = new ArrayList();
    private Map<String, PropertyDC> properties = new TreeMap<String, PropertyDC>();
    public final ConfigCategoryDC parent;
    private boolean changed = false;

    public ConfigCategoryDC(String name) {
        this(name, null);
    }

    public ConfigCategoryDC(String name, ConfigCategoryDC parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategoryDC) {
            ConfigCategoryDC cat = (ConfigCategoryDC)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getQualifiedName() {
        return ConfigCategoryDC.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategoryDC parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public ConfigCategoryDC getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map<String, PropertyDC> getValues() {
        return ImmutableMap.copyOf(this.properties);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public PropertyDC get(String key) {
        return this.properties.get(key);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (int x = 0; x < data.length; ++x) {
            out.write(data[x]);
        }
        if (new_line) {
            out.write(DCsConfiguration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        String pad2 = this.getIndent(indent + 2);
        this.write(out, pad0, "####################");
        this.write(out, pad0, "# ", this.name);
        if (this.comment != null) {
            this.write(out, pad0, "#===================");
            Splitter splitter = Splitter.onPattern((String)"\r?\n");
            for (String line : splitter.split((CharSequence)this.comment)) {
                this.write(out, pad0, "# ", line);
            }
        }
        this.write(out, pad0, "####################", DCsConfiguration.NEW_LINE);
        if (!DCsConfiguration.allowedProperties.matchesAllOf((CharSequence)this.name)) {
            this.name = '\"' + this.name + '\"';
        }
        this.write(out, pad0, this.name, " {");
        PropertyDC[] props = this.properties.values().toArray(new PropertyDC[this.properties.size()]);
        for (int x = 0; x < props.length; ++x) {
            String propName;
            PropertyDC prop = props[x];
            if (prop.comment != null) {
                if (x != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)prop.comment)) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!DCsConfiguration.allowedProperties.matchesAllOf((CharSequence)(propName = prop.getName()))) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                char type = prop.getType().getID();
                this.write(out, pad1, String.valueOf(type), ":", propName, " <");
                for (String line : prop.getStringList()) {
                    this.write(out, pad2, line);
                }
                this.write(out, pad1, " >");
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, pad1, propName, "=", prop.getString());
                continue;
            }
            char type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getString());
        }
        for (ConfigCategoryDC child : this.children) {
            child.write(out, indent + 1);
        }
        this.write(out, pad0, "}", DCsConfiguration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < indent; ++x) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (PropertyDC prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (PropertyDC prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public PropertyDC get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public PropertyDC put(String key, PropertyDC value) {
        this.changed = true;
        return this.properties.put(key, value);
    }

    @Override
    public PropertyDC remove(Object key) {
        this.changed = true;
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends PropertyDC> m) {
        this.changed = true;
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<PropertyDC> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, PropertyDC>> entrySet() {
        return ImmutableSet.copyOf(this.properties.entrySet());
    }

    public Set<ConfigCategoryDC> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    public void removeChild(ConfigCategoryDC child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.changed = true;
        }
    }
}

