/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.asm;

import mods.defeatedcrow.asm.AppleMilkCorePlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PotionArrayEXTransformer2
implements IClassTransformer,
Opcodes {
    private static final String TARGET_CLASS_NAME = "net.minecraft.potion.Potion";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!AppleMilkCorePlugin.allowLoad || AppleMilkCorePlugin.forcedDisable) {
            return basicClass;
        }
        if (!transformedName.equals(TARGET_CLASS_NAME)) {
            return basicClass;
        }
        try {
            AppleMilkCorePlugin.logger.info("Start transforming Potion Class");
            ClassReader classReader = new ClassReader(basicClass);
            ClassWriter classWriter = new ClassWriter(1);
            classReader.accept((ClassVisitor)new CustomVisitor(name, (ClassVisitor)classWriter), 8);
            AppleMilkCorePlugin.logger.info("Finish transforming Potion Class");
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("failed : PotionArrayTransformer loading", e);
        }
    }

    private byte[] extendPotionArray(String target, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String targetMethodName = "<clinit>";
        MethodNode mnode = null;
        for (MethodNode curMnode : classNode.methods) {
            if (!targetMethodName.equals(curMnode.name)) continue;
            mnode = curMnode;
            break;
        }
        if (mnode != null) {
            AppleMilkCorePlugin.logger.info("Transforming static init method");
            AbstractInsnNode oldInsnNode = mnode.instructions.get(2);
            VarInsnNode newInsnNode = new VarInsnNode(16, AppleMilkCorePlugin.range);
            mnode.instructions.set(oldInsnNode, (AbstractInsnNode)newInsnNode);
            ClassWriter cw = new ClassWriter(3);
            classNode.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        }
        return bytes;
    }

    class CustomMethodVisitor
    extends MethodVisitor {
        static final int targetOpcode = 16;
        static final int targetOperand = 32;
        static final int newOperand = 127;

        public CustomMethodVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (16 == opcode && 32 == operand) {
                AppleMilkCorePlugin.logger.info("Change BIPUSH 32 to " + AppleMilkCorePlugin.range);
                super.visitFieldInsn(178, "mods/defeatedcrow/asm/AppleMilkCorePlugin", "range", "I");
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }
    }

    class CustomVisitor
    extends ClassVisitor {
        String owner;
        static final String targetMethodName = "<clinit>";
        static final String targetMethodDesc = "()V";

        public CustomVisitor(String owner, ClassVisitor cv) {
            super(262144, cv);
            this.owner = owner;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (targetMethodName.equals(name) && targetMethodDesc.equals(desc)) {
                AppleMilkCorePlugin.logger.info("Transforming static init method");
                return new CustomMethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

