/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cofh.lib.inventory.ComparableItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jotato.quantumflux.blocks.ModBlocks;
import jotato.quantumflux.items.ModItems;
import jotato.quantumflux.machine.fabricator.ContainerItemFabricator;
import jotato.quantumflux.machine.fabricator.ItemFabricatorRecipeManager;
import jotato.quantumflux.nei.ItemFabricatorNEIHandler;
import jotato.quantumflux.util.SimplePosition;
import net.minecraft.item.ItemStack;

public class NEIQuantumFluxConfig
implements IConfigureNEI {
    private static HashMap<List<PositionedStack>, PositionedStack> itemFabricatorRecipes = new HashMap();
    private static ItemFabricatorNEIHandler itemFabricatorNEIHandler;

    public NEIQuantumFluxConfig() {
        itemFabricatorNEIHandler = new ItemFabricatorNEIHandler();
    }

    public String getName() {
        return "QuantumFlux";
    }

    public String getVersion() {
        return "1.7.10-1.3.2-b4";
    }

    public void loadConfig() {
        this.loadRecipes();
        API.registerRecipeHandler((ICraftingHandler)itemFabricatorNEIHandler);
        API.registerUsageHandler((IUsageHandler)itemFabricatorNEIHandler);
        API.hideItem((ItemStack)new ItemStack(ModBlocks.creativeCluster));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.quibitCluster_1));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.quibitCluster_2));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.quibitCluster_3));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.quibitCluster_4));
        API.hideItem((ItemStack)new ItemStack(ModBlocks.quibitCluster_5));
        API.hideItem((ItemStack)new ItemStack(ModItems.manganese));
        API.hideItem((ItemStack)new ItemStack(ModItems.harmonicOscillator));
        API.hideItem((ItemStack)new ItemStack(ModItems.titaniumPlate));
        API.hideItem((ItemStack)new ItemStack(ModItems.goldCasing));
    }

    private void loadRecipes() {
        this.loadItemFabricator();
    }

    private void loadItemFabricator() {
        SimplePosition slot1 = ContainerItemFabricator.slot1;
        SimplePosition slot2 = ContainerItemFabricator.slot2;
        SimplePosition slotOut = ContainerItemFabricator.slotOut;
        for (Map.Entry<List<ComparableItemStack>, ItemFabricatorRecipeManager.InfuserRecipe> recipe : ItemFabricatorRecipeManager.getRecipes().entrySet()) {
            ArrayList<PositionedStack> key = new ArrayList<PositionedStack>();
            ItemFabricatorRecipeManager.InfuserRecipe iRecipe = recipe.getValue();
            key.add(new PositionedStack((Object)iRecipe.getFirstInput(), slot1.X - 5, slot1.Y + 10));
            key.add(new PositionedStack((Object)iRecipe.getSecondInput(), slot2.X - 5, slot2.Y + 10));
            itemFabricatorRecipes.put(key, new PositionedStack((Object)iRecipe.getResult(), slotOut.X - 5, slotOut.Y + 10));
        }
    }

    public static Set<Map.Entry<List<PositionedStack>, PositionedStack>> getIitemFabricatorRecipes() {
        return itemFabricatorRecipes.entrySet();
    }
}

