/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.entropyaccelerator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jotato.quantumflux.ConfigMan;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEntropyAccelerator
extends TileEntity
implements IInventory,
IEnergyProvider {
    private ItemStack fuelStack;
    private int currentBurnTime = 0;
    private EnergyStorage energy;
    public int maxBurnTime = ConfigMan.incinerator_burnTime;
    public boolean isBurning = false;

    public TileEntityEntropyAccelerator() {
        this.energy = new EnergyStorage(ConfigMan.incinerator_buffer, Integer.MAX_VALUE, ConfigMan.incinerator_output);
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.fuelStack;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.fuelStack != null) {
            if (this.fuelStack.field_77994_a <= size) {
                ItemStack itemstack = this.fuelStack;
                this.fuelStack = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.fuelStack.func_77979_a(size);
            if (this.fuelStack.field_77994_a == 0) {
                this.fuelStack = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.fuelStack = itemstack;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public boolean isActive() {
        return (this.hasFuel() || this.isBurning) && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("currentBurnTime", (short)this.currentBurnTime);
        NBTTagCompound fuelTag = new NBTTagCompound();
        if (this.fuelStack != null) {
            this.fuelStack.func_77955_b(fuelTag);
        }
        tag.func_74782_a("Items", (NBTBase)fuelTag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74757_a("Burning", this.isBurning);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound fuelTag = tag.func_74775_l("Items");
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.fuelStack = ItemStack.func_77949_a((NBTTagCompound)fuelTag);
        this.currentBurnTime = tag.func_74765_d("currentBurnTime");
        this.energy.readFromNBT(energyTag);
        this.isBurning = tag.func_74767_n("Burning");
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.currentBurnTime == 0) {
                    this.isBurning = true;
                    --this.fuelStack.field_77994_a;
                    if (this.fuelStack.field_77994_a == 0) {
                        this.fuelStack = null;
                    }
                }
                this.energy.receiveEnergy(ConfigMan.incinerator_output, false);
                ++this.currentBurnTime;
                if (this.currentBurnTime >= this.maxBurnTime) {
                    this.currentBurnTime = 0;
                    this.isBurning = false;
                }
                this.func_70296_d();
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IEnergyReceiver receiver;
                int targetX = this.field_145851_c + dir.offsetX;
                int targetY = this.field_145848_d + dir.offsetY;
                int targetZ = this.field_145849_e + dir.offsetZ;
                TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
                if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite())) continue;
                int tosend = this.energy.extractEnergy(ConfigMan.incinerator_output, true);
                int used = ((IEnergyReceiver)tile).receiveEnergy(dir.getOpposite(), tosend, false);
                if (used > 0) {
                    this.func_70296_d();
                }
                this.energy.extractEnergy(used, false);
            }
        }
    }

    public void setEnergyStored(int value) {
        this.func_70296_d();
        this.energy.setEnergyStored(value);
    }

    private boolean hasFuel() {
        return this.fuelStack != null && this.fuelStack.field_77994_a > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        return this.getEnergyStored(null) * scale / this.getMaxEnergyStored(null);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int toget = this.energy.extractEnergy(maxExtract, simulate);
        if (toget > 0 && !simulate) {
            this.func_70296_d();
        }
        return toget;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }
}

