/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.cluster;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.redflux.ISetEnergy;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityQuibitCluster_Deprecated
extends TileEntity
implements IEnergyHandler,
ISetEnergy {
    protected EnergyStorage localEnergyStorage;
    private int transferRate;
    private int capacity;
    public int level;

    public TileEntityQuibitCluster_Deprecated(int transferRate, int capacity, int level) {
        this.transferRate = transferRate;
        this.capacity = capacity;
        this.level = level;
        for (int i = 1; i < level; ++i) {
            this.transferRate *= ConfigMan.quibitCluster_multiplier;
            this.capacity *= ConfigMan.quibitCluster_multiplier;
        }
        if (level == 5) {
            this.transferRate = Integer.MAX_VALUE;
        }
        this.localEnergyStorage = new EnergyStorage(this.capacity, this.transferRate);
    }

    protected EnergyStorage getEnergyDevice() {
        return this.localEnergyStorage;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyTransferRate() {
        return this.transferRate;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int used = this.getEnergyDevice().receiveEnergy(maxReceive, simulate);
        if (used > 0 && !simulate) {
            this.func_70296_d();
        }
        return used;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int given = this.getEnergyDevice().extractEnergy(maxExtract, simulate);
        if (given > 0 && !simulate) {
            this.func_70296_d();
        }
        return given;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyDevice().getEnergyStored();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.func_70296_d();
        this.getEnergyDevice().setEnergyStored(energy);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getEnergyDevice().getMaxEnergyStored();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.getEnergyDevice().writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74768_a("XferRate", this.transferRate);
        tag.func_74768_a("Capacity", this.capacity);
        tag.func_74768_a("Level", this.level);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.getEnergyDevice().readFromNBT(energyTag);
        this.level = tag.func_74762_e("Level");
        this.capacity = tag.func_74762_e("Capacity");
        this.transferRate = tag.func_74762_e("XferRate");
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        double stored = this.getEnergyStored(null);
        double max = this.getMaxEnergyStored(null);
        double v = stored / max * (double)scale;
        return (int)v;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyReceiver receiver;
            int targetX = this.field_145851_c + dir.offsetX;
            int targetY = this.field_145848_d + dir.offsetY;
            int targetZ = this.field_145849_e + dir.offsetZ;
            TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
            if (tile instanceof TileEntityQuibitCluster_Deprecated) {
                return;
            }
            if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite())) continue;
            int tosend = this.localEnergyStorage.extractEnergy(this.transferRate, true);
            int used = ((IEnergyReceiver)tile).receiveEnergy(dir.getOpposite(), tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.localEnergyStorage.extractEnergy(used, false);
        }
        super.func_145845_h();
    }
}

