/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.rituals;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tombenpotter.sanguimancy.util.RitualUtils;

public class RitualEffectFelling
extends RitualEffect {
    public static final int reagentDrain = 5;

    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
        World world = ritualStone.getWorld();
        if (world.func_72820_D() % 10L != 5L) {
            return;
        }
        int x = ritualStone.getXCoord();
        TileEntity tile = world.func_147438_o(x, (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory)) {
            return;
        }
        IInventory tileEntity = (IInventory)tile;
        if (tileEntity.func_70302_i_() <= 0) {
            return;
        }
        boolean hasRoom = false;
        for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
            if (tileEntity.func_70301_a(i) != null) continue;
            hasRoom = true;
            break;
        }
        if (!hasRoom) {
            return;
        }
        boolean hasCrystallos = this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 5, false);
        boolean hasIncendium = this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 5, false);
        boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 5, true);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 5, true);
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 5, true);
        if (currentEssence < this.getCostPerRefresh()) {
            EntityPlayer entityOwner = SpellHelper.getPlayerForUsername((String)owner);
            if (entityOwner == null) {
                return;
            }
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
        } else {
            for (int i = 0; i < 6; ++i) {
                SpellHelper.sendIndexedParticleToAllAround((World)world, (double)x, (double)y, (double)z, (int)20, (int)world.field_73011_w.field_76574_g, (int)3, (double)x, (double)y, (double)z);
            }
            ArrayList<Object> harvestables = new ArrayList();
            int rangeMultiplier = RitualUtils.getRangeMultiplier(hasTerrae, hasOrbisTerrae);
            int timeDivider = 1;
            if (harvestables.isEmpty()) {
                if (hasPotentia) {
                    timeDivider = 2;
                }
                harvestables = RitualUtils.TimbermanUtils.getHarvestablesInArea(world, x, y, z, 8 * rangeMultiplier);
            }
            for (Int3 int3 : harvestables) {
                if (world.field_73012_v.nextInt(10 / timeDivider) != 0) continue;
                Block block = world.func_147439_a(int3.xCoord, int3.yCoord, int3.zCoord);
                if (world.func_147437_c(int3.xCoord, int3.yCoord, int3.zCoord) || !block.isLeaves((IBlockAccess)world, int3.xCoord, int3.yCoord, int3.zCoord) && !block.isWood((IBlockAccess)world, int3.xCoord, int3.yCoord, int3.zCoord)) continue;
                if (hasCrystallos) {
                    RitualUtils.silkPlaceInInventory(block, world, int3.xCoord, int3.yCoord, int3.zCoord, tileEntity);
                    this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 5, true);
                } else if (hasIncendium) {
                    RitualUtils.smeltPlaceInInventory(block, world, int3.xCoord, int3.yCoord, int3.zCoord, tileEntity);
                    this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 5, true);
                } else {
                    RitualUtils.placeInInventory(block, world, int3.xCoord, int3.yCoord, int3.zCoord, tileEntity);
                }
                world.func_147468_f(int3.xCoord, int3.yCoord, int3.zCoord);
                SoulNetworkHandler.syphonFromNetwork((String)owner, (int)this.getCostPerRefresh());
            }
            harvestables.clear();
        }
    }

    public int getCostPerRefresh() {
        return 30;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> fellingRitual = new ArrayList<RitualComponent>();
        fellingRitual.add(new RitualComponent(1, 0, 0, 3));
        fellingRitual.add(new RitualComponent(-1, 0, 0, 3));
        fellingRitual.add(new RitualComponent(0, 0, 1, 3));
        fellingRitual.add(new RitualComponent(0, 0, -1, 3));
        fellingRitual.add(new RitualComponent(1, 1, 1, 3));
        fellingRitual.add(new RitualComponent(-1, 1, 1, 3));
        fellingRitual.add(new RitualComponent(-1, 1, -1, 3));
        fellingRitual.add(new RitualComponent(1, 1, -1, 3));
        return fellingRitual;
    }
}

