/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile.tank;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.tile.IPaintable;
import latmod.core.tile.IWailaTile;
import latmod.core.tile.Tank;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.tile.tank.TileTankBase;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileTank
extends TileTankBase
implements IWailaTile.Body {
    private Integer prevFluidAmmount = null;

    public TileTank() {
        this.tank = new Tank("Tank", 2147483.647);
    }

    public TileTank(int meta) {
        this();
        if (meta == 0) {
            this.tank.setCapacity(1.0);
        } else if (meta == 1) {
            this.tank.setCapacity(8.0);
        } else if (meta == 2) {
            this.tank.setCapacity(64.0);
        } else if (meta == 3) {
            this.tank.setCapacity(512.0);
        } else if (meta == 4) {
            this.tank.setCapacity(4096.0);
        } else if (meta == 5) {
            this.tank.setCapacity(2147483.647);
        }
        this.field_145847_g = meta;
    }

    public boolean rerenderBlock() {
        return true;
    }

    @Override
    public void readTileData(NBTTagCompound tag) {
        this.tick = tag.func_74763_f("Tick");
        this.tank.fluidTank.setCapacity(tag.func_74762_e("TankCap"));
        this.tank.readFromNBT(tag);
    }

    @Override
    public void writeTileData(NBTTagCompound tag) {
        tag.func_74772_a("Tick", this.tick);
        tag.func_74768_a("TankCap", this.tank.getCapacity());
        this.tank.writeToNBT(tag);
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is) {
        super.onPlacedBy(ep, is);
        if (is.func_77942_o() && is.field_77990_d.func_74764_b("Fluid")) {
            this.tank.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)is.field_77990_d.func_74775_l("Fluid")));
        }
    }

    public void onUpdate() {
        if (this.isServer() && this.tick % 5L == 0L && (this.prevFluidAmmount == null || this.prevFluidAmmount.intValue() != this.tank.getAmount())) {
            this.prevFluidAmmount = this.tank.getAmount();
            this.func_70296_d();
        }
    }

    public ItemStack getFilled(ItemStack is) {
        IFluidContainerItem i;
        int f;
        if (this.tank.getAmount() < 1000) {
            return null;
        }
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        ItemStack is1 = InvUtils.singleCopy((ItemStack)is);
        FluidStack fs = new FluidStack(this.tank.getFluid(), 1000);
        if (is1.func_77973_b() instanceof IFluidContainerItem && (f = (i = (IFluidContainerItem)is1.func_77973_b()).fill(is1, fs, true)) == 1000) {
            return is1;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fs, (ItemStack)is1);
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        ItemStack filled;
        FluidStack liquid;
        if (is == null || is.func_77973_b() instanceof IPaintable.IPainterItem) {
            return false;
        }
        if (this.isServer() && ep.func_70093_af() && LatCoreMC.isWrench((ItemStack)is)) {
            ItemStack drop = new ItemStack((Block)LatBlocksItems.b_tank, 1, this.func_145832_p());
            if (this.tank.hasFluid(1000)) {
                NBTTagCompound tag = new NBTTagCompound();
                this.tank.getFluidStack().writeToNBT(tag);
                drop.field_77990_d = new NBTTagCompound();
                drop.field_77990_d.func_74782_a("Fluid", (NBTBase)tag);
            }
            InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)drop, (int)10);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if ((liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is)) != null) {
            int qty = this.fill(ForgeDirection.UNKNOWN, liquid, true);
            if (qty != 0 && !ep.field_71075_bZ.field_75098_d) {
                ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                ep.field_71071_by.func_70296_d();
                this.func_70296_d();
            }
            return true;
        }
        FluidStack available = this.tank.getFluidStack();
        if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)is)))) != null) {
            if (!ep.field_71075_bZ.field_75098_d) {
                if (is.field_77994_a > 1) {
                    if (!ep.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                } else {
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, filled);
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                }
            }
            this.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
            return true;
        }
        return false;
    }

    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        if (this.tank.isEmpty()) {
            info.add("Tank: Empty");
        } else {
            info.add("Tank: " + this.tank.getAmount() + " mB of " + this.tank.getFluidStack().getLocalizedName() + (this.field_145847_g == 5 ? "" : " [ " + (int)(this.tank.getAmountD() * 100.0) + "% ]"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTankBorderIcon() {
        this.getMeta();
        return LatBlocksItems.b_tank.icons[this.field_145847_g];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Fluid getTankRenderFluid() {
        return this.tank.isEmpty() ? null : this.tank.getFluid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getTankFluidHeight() {
        if (this.field_145847_g == 5 && this.tank.hasFluid()) {
            return 1.0;
        }
        return this.tank.getAmountD();
    }
}

