/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.ParticleHelper;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.ISecureTile;
import latmod.core.tile.TileInvLM;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.gui.ContainerQFurnace;
import latmod.latblocks.gui.GuiQFurnace;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQFurnace
extends TileInvLM
implements IGuiTile,
ISidedInventory,
ISecureTile {
    public static final String ITEM_TAG = "Furnace";
    public static final int MAX_ITEMS = 3;
    public static final double MAX_PROGRESS = 175.0;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public int fuel = 0;
    public int progress = 0;
    public ItemStack result = null;

    public TileQFurnace() {
        super(3);
    }

    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        this.fuel = tag.func_74762_e("Fuel");
        this.progress = tag.func_74765_d("Progress");
        this.result = InvUtils.loadStack((NBTTagCompound)tag, (String)"Result");
    }

    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        tag.func_74768_a("Fuel", this.fuel);
        tag.func_74777_a("Progress", (short)this.progress);
        InvUtils.saveStack((NBTTagCompound)tag, (String)"Result", (ItemStack)this.result);
    }

    public boolean rerenderBlock() {
        return true;
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (this.isServer() && this.security.canInteract(ep) && LatCoreMC.isWrench((ItemStack)is)) {
            if (ep.func_70093_af()) {
                this.dropItems = false;
                ItemStack drop = new ItemStack((Block)LatBlocksItems.b_qfurnace, 1, 0);
                if (this.fuel > 0 || this.result != null || this.customName != null || InvUtils.getFirstFilledIndex((IInventory)this, null, (int)-1) != -1) {
                    NBTTagCompound tag = new NBTTagCompound();
                    this.writeTileData(tag);
                    tag.func_82580_o("CustomName");
                    drop.func_77982_d(new NBTTagCompound());
                    drop.field_77990_d.func_74782_a(ITEM_TAG, (NBTBase)tag);
                    if (this.customName != null) {
                        drop.func_151001_c(this.customName);
                    }
                }
                InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)drop, (int)10);
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                if (side == 0 || side == 1) {
                    this.getMeta();
                    if (this.field_145847_g == 2) {
                        this.setMeta(5);
                    } else if (this.field_145847_g == 3) {
                        this.setMeta(4);
                    } else if (this.field_145847_g == 4) {
                        this.setMeta(2);
                    } else if (this.field_145847_g == 5) {
                        this.setMeta(3);
                    }
                } else {
                    this.setMeta(side);
                }
                this.func_70296_d();
            }
        } else if (this.isServer()) {
            if (!this.security.canInteract(ep)) {
                this.printOwner(ep);
            } else {
                LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, null);
            }
        }
        return true;
    }

    public void onUpdate() {
        if (this.fuel == 0 && this.isServer() && this.items[1] != null) {
            this.fuel = TileEntityFurnace.func_145952_a((ItemStack)this.items[1]);
            if (this.fuel > 0) {
                this.items[1] = InvUtils.reduceItem((ItemStack)this.items[1]);
                this.func_70296_d();
            }
        }
        if (this.progress == 0) {
            if (this.isServer()) {
                ItemStack out;
                ItemStack itemStack = out = this.items[0] == null ? null : FurnaceRecipes.func_77602_a().func_151395_a(this.items[0]);
                if (out != null && this.fuel > 0) {
                    this.items[0] = InvUtils.reduceItem((ItemStack)this.items[0]);
                    this.result = out.func_77946_l();
                    this.progress = 1;
                    this.func_70296_d();
                }
            }
        } else if ((double)this.progress >= 175.0) {
            if (this.result != null) {
                this.progress = 0;
                this.func_70296_d();
                if (this.items[2] == null || this.items[2].field_77994_a + this.result.field_77994_a <= this.items[2].func_77976_d()) {
                    if (this.isServer()) {
                        if (this.items[2] == null) {
                            this.items[2] = this.result.func_77946_l();
                        } else {
                            this.items[2].field_77994_a += this.result.field_77994_a;
                        }
                        this.result = null;
                    }
                    ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[this.field_145847_g];
                    double px = (double)this.field_145851_c + 0.5 + (double)fd.offsetX * 0.6;
                    double pz = (double)this.field_145849_e + 0.5 + (double)fd.offsetZ * 0.6;
                    for (int i = 0; i < 40; ++i) {
                        double r = MathHelperLM.randomDouble((Random)ParticleHelper.rand, (double)-0.25, (double)0.25);
                        double px1 = px + (fd == ForgeDirection.WEST || fd == ForgeDirection.EAST ? 0.0 : r);
                        double py = (double)this.field_145848_d + (double)ParticleHelper.rand.nextFloat() * 6.0 / 16.0;
                        double pz1 = pz + (fd == ForgeDirection.NORTH || fd == ForgeDirection.SOUTH ? 0.0 : r);
                        this.field_145850_b.func_72869_a("flame", px1, py, pz1, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (this.fuel > 0) {
            ++this.progress;
            --this.fuel;
            if (this.fuel == 0 && this.isServer()) {
                this.func_70296_d();
            }
            if (this.progress % 3 == 0) {
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[this.field_145847_g];
                double r = MathHelperLM.randomDouble((Random)ParticleHelper.rand, (double)-0.25, (double)0.25);
                double px1 = (double)this.field_145851_c + 0.5 + (double)fd.offsetX * 0.6 + (fd == ForgeDirection.WEST || fd == ForgeDirection.EAST ? 0.0 : r);
                double py = (double)this.field_145848_d + (double)ParticleHelper.rand.nextFloat() * 6.0 / 16.0;
                double pz1 = (double)this.field_145849_e + 0.5 + (double)fd.offsetZ * 0.6 + (fd == ForgeDirection.NORTH || fd == ForgeDirection.SOUTH ? 0.0 : r);
                this.field_145850_b.func_72869_a("flame", px1, py, pz1, 0.0, 0.0, 0.0);
            }
        }
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is) {
        super.onPlacedBy(ep, is);
        if (is.func_77942_o() && is.field_77990_d.func_74764_b(ITEM_TAG)) {
            this.readTileData(is.field_77990_d.func_74775_l(ITEM_TAG));
        }
        this.customName = is.func_82837_s() ? is.func_82833_r() : null;
        this.setMeta(MathHelperLM.get2DRotation((EntityLivingBase)ep).ordinal());
    }

    public boolean isLit() {
        return this.result != null && this.fuel > 0;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        return new ContainerQFurnace(ep, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        return new GuiQFurnace(new ContainerQFurnace(ep, this));
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return true;
    }

    public int[] func_94128_d(int s) {
        if (s == 0) {
            return new int[]{1};
        }
        if (s == 1) {
            return new int[]{0};
        }
        return new int[]{2};
    }

    public boolean func_102007_a(int i, ItemStack is, int s) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack is, int s) {
        return true;
    }
}

