/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.InvUtils;
import latmod.core.LMSecurity;
import latmod.core.LatCoreMC;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.ISecureTile;
import latmod.core.tile.TileInvLM;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.gui.ContainerQChest;
import latmod.latblocks.gui.GuiQChest;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQChest
extends TileInvLM
implements IGuiTile,
ISidedInventory,
ISecureTile {
    public static final String ITEM_TAG = "ChestData";
    public ForgeDirection rotation = ForgeDirection.NORTH;

    public TileQChest() {
        super(91);
    }

    public boolean rerenderBlock() {
        return true;
    }

    public void onLoaded() {
        super.onLoaded();
        this.getMeta();
        this.rotation = ForgeDirection.VALID_DIRECTIONS[this.field_145847_g];
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (this.isServer() && !ep.func_70093_af()) {
            if (!this.security.canInteract(ep)) {
                this.printOwner(ep);
            } else {
                LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, null);
            }
        } else if (this.isServer() && this.security.canInteract(ep) && LatCoreMC.isWrench((ItemStack)is)) {
            this.dropItems = false;
            ItemStack drop = new ItemStack((Block)LatBlocksItems.b_qchest, 1, 0);
            if (this.customName != null || InvUtils.getFirstFilledIndex((IInventory)this, null, (int)-1) != -1) {
                NBTTagCompound tag = new NBTTagCompound();
                this.writeTileData(tag);
                tag.func_82580_o("CustomName");
                drop.func_77982_d(new NBTTagCompound());
                drop.field_77990_d.func_74782_a(ITEM_TAG, (NBTBase)tag);
                if (this.customName != null) {
                    drop.func_151001_c(this.customName);
                }
            }
            InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)drop, (int)10);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 576.0;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        return new ContainerQChest(ep, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        return new GuiQChest(new ContainerQChest(ep, this));
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is) {
        super.onPlacedBy(ep, is);
        if (!this.field_145850_b.field_72995_K) {
            this.setMeta(MathHelperLM.get2DRotation((EntityLivingBase)ep).ordinal());
            if (is.func_77942_o() && is.field_77990_d.func_74764_b(ITEM_TAG)) {
                this.readTileData(is.field_77990_d.func_74775_l(ITEM_TAG));
            }
            this.customName = is.func_82837_s() ? is.func_82833_r() : null;
            this.func_70296_d();
        }
    }

    public void handleButton(String button, int mouseButton, EntityPlayer ep) {
        if (button.equals("security")) {
            if (ep != null && this.security.isOwner((Object)ep)) {
                this.security.level = mouseButton == 0 ? this.security.level.next(LMSecurity.Level.VALUES) : this.security.level.prev(LMSecurity.Level.VALUES);
            } else {
                this.printOwner(ep);
            }
        }
    }

    public int[] func_94128_d(int s) {
        return this.security.level.isPublic() ? this.ALL_SLOTS : NO_SLOTS;
    }

    public boolean func_102007_a(int i, ItemStack is, int s) {
        return this.security.level.isPublic();
    }

    public boolean func_102008_b(int i, ItemStack is, int s) {
        return this.security.level.isPublic();
    }
}

