/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import latmod.core.LatCoreMC;
import latmod.core.gui.ContainerEmpty;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.ISecureTile;
import latmod.core.tile.IWailaTile;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.gui.GuiNoteBoard;
import latmod.latblocks.tile.TileSinglePaintable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;

public class TileNoteBoard
extends TileSinglePaintable
implements IGuiTile,
IWailaTile.Body,
ISecureTile {
    public static final String ACTION_CHANGE_TEXT = "ChangeNoteText";
    public final String[] notes = new String[16];

    public TileNoteBoard() {
        Arrays.fill(this.notes, "");
    }

    @Override
    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        for (int i = 0; i < this.notes.length; ++i) {
            this.notes[i] = tag.func_74779_i("Note" + i);
        }
    }

    @Override
    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        for (int i = 0; i < this.notes.length; ++i) {
            if (this.notes[i].isEmpty()) continue;
            tag.func_74778_a("Note" + i, this.notes[i]);
        }
    }

    public int getIndex(MovingObjectPosition mop) {
        if (mop == null) {
            return 0;
        }
        double rx = mop.field_72307_f.field_72450_a - (double)mop.field_72311_b;
        double ry = mop.field_72307_f.field_72448_b - (double)mop.field_72312_c;
        double rz = mop.field_72307_f.field_72449_c - (double)mop.field_72309_d;
        double rx1 = 0.0;
        double ry1 = 0.0;
        if (mop.field_72310_e == 1 || mop.field_72310_e == 0) {
            rx1 = rx;
            ry1 = rz;
        } else {
            ry1 = 1.0 - ry;
            if (mop.field_72310_e == 3) {
                rx1 = rx;
            } else if (mop.field_72310_e == 2) {
                rx1 = 1.0 - rx;
            }
            if (mop.field_72310_e == 5) {
                rx1 = 1.0 - rz;
            } else if (mop.field_72310_e == 4) {
                rx1 = rz;
            }
        }
        return (int)(rx1 * 4.0) + (int)(ry1 * 4.0) * 4;
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        if (side == Facing.field_71588_a[this.field_145847_g]) {
            int index;
            if (this.isServer() && (index = this.getIndex(MathHelperLM.getMOPFrom((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)side, (float)hitX, (float)hitY, (float)hitZ))) >= 0 && index < 16) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74774_a("I", (byte)index);
                LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, (NBTTagCompound)data);
            }
            return true;
        }
        return false;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        return new ContainerEmpty(ep, null);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        return new GuiNoteBoard(new ContainerEmpty(ep, null), this, data.func_74771_c("I"));
    }

    public void onClientAction(EntityPlayer ep, String action, NBTTagCompound data) {
        if (action.equals(ACTION_CHANGE_TEXT)) {
            this.notes[data.func_74771_c((String)"ID")] = data.func_74779_i("Txt");
            this.func_70296_d();
        } else {
            super.onClientAction(ep, action, data);
        }
    }

    @Override
    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        int index;
        if (data.getPosition().field_72310_e == Facing.field_71588_a[this.field_145847_g] && (index = this.getIndex(data.getPosition())) >= 0 && index < 16 && !this.notes[index].isEmpty()) {
            info.add(this.notes[index]);
        }
    }
}

