/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.tile;

import java.util.List;
import latmod.core.InvUtils;
import latmod.core.tile.IPaintable;
import latmod.core.tile.IWailaTile;
import latmod.core.tile.Tank;
import latmod.core.tile.TileInvLM;
import latmod.latblocks.LatBlocks;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFountain
extends TileInvLM
implements IPaintable,
IFluidHandler,
ISidedInventory,
IWailaTile.Body {
    public final IPaintable.Paint[] paint = new IPaintable.Paint[1];
    public final Tank tank = new Tank("Tank", 1.0){

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            return fluid != null && fluid.getBlock() != null;
        }
    };
    private Integer prevFluidAmmount = null;

    public TileFountain() {
        super(1);
    }

    public boolean rerenderBlock() {
        return true;
    }

    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        this.tank.readFromNBT(tag);
        IPaintable.Paint.readFromNBT((NBTTagCompound)tag, (String)"Texture", (IPaintable.Paint[])this.paint);
        this.redstonePowered = tag.func_74767_n("RSIn");
    }

    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        this.tank.writeToNBT(tag);
        IPaintable.Paint.writeToNBT((NBTTagCompound)tag, (String)"Texture", (IPaintable.Paint[])this.paint);
        tag.func_74757_a("RSIn", this.redstonePowered);
    }

    public boolean setPaint(IPaintable.PaintData p) {
        if (p.canReplace(this.paint[0])) {
            this.paint[0] = p.paint;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void onNeighborBlockChange(Block b) {
        if (this.isServer()) {
            this.redstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public void onUpdate() {
        if (this.isServer() && this.tick % 20L == 0L) {
            ItemStack is1;
            if (this.prevFluidAmmount == null || this.prevFluidAmmount.intValue() != this.tank.getAmount()) {
                this.prevFluidAmmount = this.tank.getAmount();
                this.func_70296_d();
            }
            if (this.items[0] != null && this.items[0].field_77994_a == 1 && (is1 = this.getFilled(this.items[0])) != null) {
                this.items[0] = is1;
                this.tank.drain(ForgeDirection.UNKNOWN, 1000, true);
            }
        }
        if (!this.isServer() && this.redstonePowered && this.tank.hasFluid() && this.tank.getFluid().getBlock() != null) {
            LatBlocks.proxy.spawnFountainParticle(this);
        }
    }

    public ItemStack getFilled(ItemStack is) {
        IFluidContainerItem i;
        int f;
        if (this.tank.getAmount() < 1000) {
            return null;
        }
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        ItemStack is1 = InvUtils.singleCopy((ItemStack)is);
        FluidStack fs = new FluidStack(this.tank.getFluid(), 1000);
        if (is1.func_77973_b() instanceof IFluidContainerItem && (f = (i = (IFluidContainerItem)is1.func_77973_b()).fill(is1, fs, true)) == 1000) {
            return is1;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fs, (ItemStack)is1);
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        ItemStack filled;
        if (is == null) {
            this.redstonePowered = !this.redstonePowered;
            this.func_70296_d();
            return true;
        }
        if (is.func_77973_b() instanceof IPaintable.IPainterItem) {
            return false;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
        if (liquid != null) {
            int qty = this.fill(ForgeDirection.UNKNOWN, liquid, true);
            if (qty != 0 && !ep.field_71075_bZ.field_75098_d) {
                ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                ep.field_71071_by.func_70296_d();
                this.func_70296_d();
            }
            return true;
        }
        FluidStack available = this.tank.getFluidStack();
        if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)is)))) != null) {
            if (!ep.field_71075_bZ.field_75098_d) {
                if (is.field_77994_a > 1) {
                    if (!ep.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                } else {
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, InvUtils.reduceItem((ItemStack)is));
                    ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, filled);
                    ep.field_71071_by.func_70296_d();
                    this.func_70296_d();
                }
            }
            this.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
            return true;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tank.getTankInfo(from);
    }

    public String func_145825_b() {
        return "Fountain";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return true;
    }

    public int[] func_94128_d(int i) {
        return this.ALL_SLOTS;
    }

    public boolean func_102007_a(int i, ItemStack is, int s) {
        return this.getFilled(is) != null;
    }

    public boolean func_102008_b(int i, ItemStack is, int s) {
        return this.getFilled(is) == null;
    }

    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        if (this.tank.isEmpty()) {
            info.add("Tank: Empty");
        } else {
            info.add("Tank: " + this.tank.getAmount() + " mB of " + this.tank.getFluidStack().getLocalizedName());
        }
    }
}

