/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksConfig;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockPaintableSingle;
import latmod.latblocks.tile.TilePaintableLB;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPWall
extends BlockPaintableSingle {
    public BlockPWall(String s) {
        super(s, 1.0f);
    }

    @Override
    public TilePaintableLB createNewTileEntity(World w, int m) {
        return new TilePWall();
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 6), new Object[]{"PPP", "PPP", Character.valueOf('P'), LatBlocksItems.b_paintable});
    }

    @Override
    public void addCollisionBoxes(World w, int x, int y, int z, int m, FastList<AxisAlignedBB> boxes, Entity e) {
        double p = 0.5;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        if (this.canConnect((IBlockAccess)w, x - 1, y, z)) {
            x0 = -d;
        }
        if (this.canConnect((IBlockAccess)w, x + 1, y, z)) {
            x1 = 1.0 + d;
        }
        if (this.canConnect((IBlockAccess)w, x, y, z - 1)) {
            z0 = -d;
        }
        if (this.canConnect((IBlockAccess)w, x, y, z + 1)) {
            z1 = 1.0 + d;
        }
        double h = 1.5;
        if (LatBlocksConfig.General.fencesIgnorePlayers && e instanceof EntityPlayer) {
            h = 1.0;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)h, (double)z1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        double p = 0.5;
        double p2 = 0.375;
        double h2 = 0.8125;
        boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.5, (double)p, (double)1.0, (double)p));
        boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)h2, (double)p2));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        double p = 0.5;
        double p2 = 0.375;
        double h = 0.8125;
        boolean canConnectZN = this.canConnect(iba, x, y, z - 1);
        boolean canConnectXN = this.canConnect(iba, x - 1, y, z);
        boolean canConnectZP = this.canConnect(iba, x, y, z + 1);
        boolean canConnectXP = this.canConnect(iba, x + 1, y, z);
        if (canConnectZN) {
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.25, (double)p2, (double)h, (double)0.5));
        }
        if (canConnectXN) {
            boxes.add((Object)MathHelperLM.getBox((double)0.25, (double)0.0, (double)0.5, (double)0.5, (double)h, (double)p2));
        }
        if (canConnectZP) {
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.75, (double)p2, (double)h, (double)0.5));
        }
        if (canConnectXP) {
            boxes.add((Object)MathHelperLM.getBox((double)0.75, (double)0.0, (double)0.5, (double)0.5, (double)h, (double)p2));
        }
        if (!((canConnectZN && canConnectZP && !canConnectXN && !canConnectXP || !canConnectZN && !canConnectZP && canConnectXN && canConnectXP) && iba.func_147437_c(x, y + 1, z))) {
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.5, (double)p, (double)1.0, (double)p));
        }
    }

    @Override
    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        double p = 0.5;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        boolean canConnectZN = this.canConnect(iba, x, y, z - 1);
        boolean canConnectXN = this.canConnect(iba, x - 1, y, z);
        boolean canConnectZP = this.canConnect(iba, x, y, z + 1);
        boolean canConnectXP = this.canConnect(iba, x + 1, y, z);
        if (canConnectZN) {
            z0 = -d;
        }
        if (canConnectXN) {
            x0 = -d;
        }
        if (canConnectZP) {
            z1 = 1.0 + d;
        }
        if (canConnectXP) {
            x1 = 1.0 + d;
        }
        double h = 0.8125;
        if (!((canConnectZN && canConnectZP && !canConnectXN && !canConnectXP || !canConnectZN && !canConnectZP && canConnectXN && canConnectXP) && iba.func_147437_c(x, y + 1, z))) {
            h = 1.0;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)h, (double)z1));
    }

    public boolean canConnect(IBlockAccess iba, int x, int y, int z) {
        return LatBlocksItems.b_fence.canConnect(iba, x, y, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    public static class TilePWall
    extends TileSinglePaintable {
    }
}

