/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.LatCoreMC;
import latmod.core.tile.TileLM;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockLB;
import latmod.latblocks.client.render.world.RenderPSlope;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPSlope
extends BlockLB {
    public BlockPSlope(String s) {
        super(s, Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149658_d("paintable");
        this.field_149758_A = true;
        this.mod.addTile(TilePSlope.class, s, new String[0]);
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 4), new Object[]{"B  ", "BC ", "BBB", Character.valueOf('C'), LatBlocksItems.b_cover, Character.valueOf('B'), LatBlocksItems.b_paintable});
    }

    public TileLM createNewTileEntity(World w, int m) {
        return new TilePSlope();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderPSlope.instance.getRenderId();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess iba, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iba, int x, int y, int z, ForgeDirection side) {
        TilePSlope t = (TilePSlope)iba.func_147438_o(x, y, z);
        if (t != null && t.isValid()) {
            return t.isSolid(side.ordinal());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        return true;
    }

    public static class TilePSlope
    extends TileSinglePaintable {
        public byte yaw = 0;
        public byte pitch = (byte)-1;

        @Override
        public void readTileData(NBTTagCompound tag) {
            super.readTileData(tag);
            this.yaw = tag.func_74771_c("Yaw");
            this.pitch = tag.func_74771_c("Pitch");
        }

        @Override
        public void writeTileData(NBTTagCompound tag) {
            super.writeTileData(tag);
            tag.func_74774_a("Yaw", this.yaw);
            tag.func_74774_a("Pitch", this.pitch);
        }

        public void onPlacedBy(EntityPlayer ep, ItemStack is) {
            super.onPlacedBy(ep, is);
            int side = MathHelperLM.rayTrace((EntityPlayer)ep).field_72310_e;
            this.pitch = side == 0 ? (byte)1 : (side == 1 ? (byte)0 : (byte)-1);
            this.yaw = (byte)MathHelperLM.get2DRotation((EntityLivingBase)ep).ordinal();
            if (this.isServer()) {
                LatCoreMC.printChat((ICommandSender)ep, (Object)("Yaw: " + this.yaw + ", Pitch: " + this.pitch + ", Side: " + side));
            }
            this.func_70296_d();
        }

        public boolean isSolid(int side) {
            return this.yaw != side && this.pitch != side;
        }
    }
}

