/*
 * Decompiled with CFR 0.152.
 */
package latmod.latblocks.block.paintable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;
import latmod.latblocks.LatBlocksConfig;
import latmod.latblocks.LatBlocksItems;
import latmod.latblocks.block.BlockPaintableSingle;
import latmod.latblocks.item.ItemMaterialsLB;
import latmod.latblocks.tile.TilePaintableLB;
import latmod.latblocks.tile.TileSinglePaintable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPFence
extends BlockPaintableSingle {
    public BlockPFence(String s) {
        super(s, 1.0f);
    }

    @Override
    public TilePaintableLB createNewTileEntity(World w, int m) {
        return new TilePFence();
    }

    public void loadRecipes() {
        this.mod.recipes.addRecipe(new ItemStack((Block)this, 2), new Object[]{"SSS", "SSS", Character.valueOf('S'), ItemMaterialsLB.ROD});
    }

    @Override
    public void addCollisionBoxes(World w, int x, int y, int z, int m, FastList<AxisAlignedBB> boxes, Entity e) {
        double p = 0.25;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        if (this.canConnect((IBlockAccess)w, x - 1, y, z)) {
            x0 = -d;
        }
        if (this.canConnect((IBlockAccess)w, x + 1, y, z)) {
            x1 = 1.0 + d;
        }
        if (this.canConnect((IBlockAccess)w, x, y, z - 1)) {
            z0 = -d;
        }
        if (this.canConnect((IBlockAccess)w, x, y, z + 1)) {
            z1 = 1.0 + d;
        }
        double h = 1.5;
        if (LatBlocksConfig.General.fencesIgnorePlayers && e instanceof EntityPlayer) {
            h = 1.0;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)h, (double)z1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemRenderBoxes(FastList<AxisAlignedBB> boxes) {
        double p = 0.25;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double ds = 0.0625;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)ds, (double)0.0, (double)pn, (double)(ds + p), (double)1.0, (double)pp));
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)(1.0 - (ds + p)), (double)0.0, (double)pn, (double)(1.0 - ds), (double)1.0, (double)pp));
        double h1n = 0.25;
        double h1p = 0.375;
        double h2n = 0.625;
        double h2p = 0.75;
        double dd = 0.125;
        double z0 = 0.5 - dd / 2.0;
        double z1 = 0.5 + dd / 2.0;
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)h1n, (double)z0, (double)1.0, (double)h1p, (double)z1));
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)0.0, (double)h2n, (double)z0, (double)1.0, (double)h2p, (double)z1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(FastList<AxisAlignedBB> boxes, DrawBlockHighlightEvent event) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRenderBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        double p = 0.25;
        double h1n = 0.25;
        double h1p = 0.375;
        double h2n = 0.625;
        double h2p = 0.75;
        boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)0.0, (double)0.5, (double)p, (double)1.0, (double)p));
        if (this.canConnect(iba, x, y, z - 1)) {
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)h1n, (double)0.25, (double)0.125, (double)h1p, (double)0.5));
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)h2n, (double)0.25, (double)0.125, (double)h2p, (double)0.5));
        }
        if (this.canConnect(iba, x - 1, y, z)) {
            boxes.add((Object)MathHelperLM.getBox((double)0.25, (double)h1n, (double)0.5, (double)0.5, (double)h1p, (double)0.125));
            boxes.add((Object)MathHelperLM.getBox((double)0.25, (double)h2n, (double)0.5, (double)0.5, (double)h2p, (double)0.125));
        }
        if (this.canConnect(iba, x, y, z + 1)) {
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)h1n, (double)0.75, (double)0.125, (double)h1p, (double)0.5));
            boxes.add((Object)MathHelperLM.getBox((double)0.5, (double)h2n, (double)0.75, (double)0.125, (double)h2p, (double)0.5));
        }
        if (this.canConnect(iba, x + 1, y, z)) {
            boxes.add((Object)MathHelperLM.getBox((double)0.75, (double)h1n, (double)0.5, (double)0.5, (double)h1p, (double)0.125));
            boxes.add((Object)MathHelperLM.getBox((double)0.75, (double)h2n, (double)0.5, (double)0.5, (double)h2p, (double)0.125));
        }
    }

    @Override
    public void addBoxes(FastList<AxisAlignedBB> boxes, IBlockAccess iba, int x, int y, int z, int m) {
        double p = 0.25;
        double pn = 0.5 - p / 2.0;
        double pp = 0.5 + p / 2.0;
        double x0 = pn;
        double x1 = pp;
        double z0 = pn;
        double z1 = pp;
        double d = 0.01;
        if (this.canConnect(iba, x - 1, y, z)) {
            x0 = -d;
        }
        if (this.canConnect(iba, x + 1, y, z)) {
            x1 = 1.0 + d;
        }
        if (this.canConnect(iba, x, y, z - 1)) {
            z0 = -d;
        }
        if (this.canConnect(iba, x, y, z + 1)) {
            z1 = 1.0 + d;
        }
        boxes.add((Object)AxisAlignedBB.func_72330_a((double)x0, (double)0.0, (double)z0, (double)x1, (double)1.0, (double)z1));
    }

    public boolean canConnect(IBlockAccess iba, int x, int y, int z) {
        Block b = iba.func_147439_a(x, y, z);
        return b == this || b == Blocks.field_150396_be || b == LatBlocksItems.b_fence_gate || b.func_149688_o().func_76218_k();
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    public static class TilePFence
    extends TileSinglePaintable {
    }
}

