/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cofh.lib.util.position.BlockPosition;
import matteroverdrive.api.network.IMatterNetworkCable;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.packets.MatterNetworkBroadcastPacket;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkHelper {
    public static boolean broadcastPacketInDirection(World world, MatterNetworkPacket packet, IMatterNetworkConnection source, ForgeDirection direction) {
        if (source.canConnectFromSide(direction)) {
            IMatterNetworkConnection connection;
            BlockPosition position = source.getPosition().step(direction);
            ForgeDirection oppositeDirection = direction.getOpposite();
            TileEntity e = position.getTileEntity(world);
            if (e instanceof IMatterNetworkConnection && !packet.hasPassedTrough(connection = (IMatterNetworkConnection)e) && connection.canConnectFromSide(oppositeDirection)) {
                IMatterNetworkClient c;
                if (connection instanceof IMatterNetworkCable) {
                    IMatterNetworkCable cable = (IMatterNetworkCable)connection;
                    if (cable.isValid()) {
                        cable.broadcast(packet, direction);
                        return true;
                    }
                } else if (connection instanceof IMatterNetworkClient && (c = (IMatterNetworkClient)connection).canPreform(packet)) {
                    c.queuePacket(packet, oppositeDirection);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean broadcastPacketInDirection(World world, byte queueID, MatterNetworkTask task, IMatterNetworkDispatcher dispatcher, ForgeDirection direction) {
        return MatterNetworkHelper.broadcastPacketInDirection(world, queueID, task, dispatcher, direction, null);
    }

    public static boolean broadcastPacketInDirection(World world, byte queueID, MatterNetworkTask task, IMatterNetworkDispatcher dispatcher, ForgeDirection direction, NBTTagCompound filter) {
        return MatterNetworkHelper.broadcastPacketInDirection(world, new MatterNetworkTaskPacket(dispatcher, task, queueID, direction, filter), dispatcher, direction);
    }

    public static NBTTagCompound getFilterFromPositions(BlockPosition ... positions) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < positions.length; ++i) {
            NBTTagCompound positionNBT = new NBTTagCompound();
            positions[i].writeToNBT(positionNBT);
            tagList.func_74742_a((NBTBase)positionNBT);
        }
        tagCompound.func_74782_a("CONNECTIONS", (NBTBase)tagList);
        return tagCompound;
    }

    public static NBTTagCompound addPositionsToFilter(NBTTagCompound filter, BlockPosition ... positions) {
        if (filter == null) {
            filter = new NBTTagCompound();
        }
        NBTTagList tagList = filter.func_150295_c("CONNECTIONS", 10);
        for (int i = 0; i < positions.length; ++i) {
            NBTTagCompound positionNBT = new NBTTagCompound();
            positions[i].writeToNBT(positionNBT);
            tagList.func_74742_a((NBTBase)positionNBT);
        }
        filter.func_74782_a("CONNECTIONS", (NBTBase)tagList);
        return filter;
    }

    public static void broadcastConnection(World world, IMatterNetworkConnection connection) {
        for (int i = 0; i < 6; ++i) {
            MatterNetworkBroadcastPacket packet = new MatterNetworkBroadcastPacket(connection.getPosition(), 0, ForgeDirection.getOrientation((int)i));
            MatterNetworkHelper.broadcastPacketInDirection(world, packet, connection, ForgeDirection.getOrientation((int)i));
        }
    }

    public static void requestNeighborConnections(World world, IMatterNetworkConnection connection) {
        for (int i = 0; i < 6; ++i) {
            MatterNetworkRequestPacket packet = new MatterNetworkRequestPacket(connection, 2, ForgeDirection.getOrientation((int)i), null);
            MatterNetworkHelper.broadcastPacketInDirection(world, packet, connection, ForgeDirection.getOrientation((int)i));
        }
    }

    public static void respondToRequest(World world, IMatterNetworkConnection sender, MatterNetworkRequestPacket packet, int responseType, NBTTagCompound data) {
        if (packet.getSender(world) instanceof IMatterNetworkClient) {
            MatterNetworkResponsePacket responsePacket = new MatterNetworkResponsePacket(sender, responseType, packet.getRequestType(), data, packet.getSenderPort());
            ((IMatterNetworkClient)packet.getSender(world)).queuePacket(responsePacket, packet.getSenderPort());
        }
    }
}

