/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cofh.lib.util.helpers.MathHelper;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class MatterDatabaseHelper {
    public static final int MAX_ITEM_PROGRESS = 100;
    public static final String PROGRESS_TAG_NAME = "scan_progress";
    public static final String ITEMS_TAG_NAME = "items";
    public static final String CAPACITY_TAG_NAME = "Capacity";

    public static void InitTagCompound(ItemStack scanner) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        scanner.func_77982_d(tagCompound);
        MatterDatabaseHelper.InitItemListTagCompound(scanner);
    }

    public static void InitItemListTagCompound(ItemStack scanner) {
        NBTTagList items = new NBTTagList();
        scanner.func_77983_a(ITEMS_TAG_NAME, (NBTBase)items);
    }

    public static int GetPatternCapacity(NBTTagCompound storageCompund) {
        if (storageCompund != null) {
            return storageCompund.func_74765_d(CAPACITY_TAG_NAME);
        }
        return 0;
    }

    public static boolean HasFreeSpace(ItemStack storage) {
        if (storage != null && MatterHelper.isMatterPatternStorage(storage)) {
            if (storage.func_77942_o()) {
                return MatterDatabaseHelper.HasFreeSpace(storage.func_77978_p());
            }
            return true;
        }
        return false;
    }

    public static boolean HasFreeSpace(NBTTagCompound storageCompund) {
        NBTTagList itemList;
        return storageCompund != null && (itemList = storageCompund.func_150295_c(ITEMS_TAG_NAME, 10)).func_74745_c() < MatterDatabaseHelper.GetPatternCapacity(storageCompund);
    }

    public static ItemStack getFirstFreePatternStorage(IMatterDatabase database) {
        ItemStack[] patternStorages = database.getPatternStorageList();
        for (int i = 0; i < patternStorages.length; ++i) {
            if (patternStorages[i] == null || !MatterDatabaseHelper.HasFreeSpace(patternStorages[i])) continue;
            return patternStorages[i];
        }
        return null;
    }

    public static boolean HasItem(ItemStack scanner, ItemStack item) {
        return MatterDatabaseHelper.HasItem(scanner.func_77978_p(), item);
    }

    public static boolean HasItem(NBTTagCompound tagcompound, ItemStack item) {
        if (tagcompound != null) {
            NBTTagList itemList = tagcompound.func_150295_c(ITEMS_TAG_NAME, 10);
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (!MatterDatabaseHelper.areEqual(MatterDatabaseHelper.GetItemStackFromNBT(itemList.func_150305_b(i)), item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean HasItem(ItemStack scanner, String id) {
        return MatterDatabaseHelper.HasItem(scanner.func_77978_p(), id);
    }

    public static boolean HasItem(NBTTagCompound tagcompound, String id) {
        NBTTagCompound items;
        if (tagcompound != null && (items = tagcompound) != null) {
            NBTTagList itemList = items.func_150295_c(ITEMS_TAG_NAME, 10);
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (MatterDatabaseHelper.GetItemStackFromNBT(itemList.func_150305_b(i)).func_77977_a() != id) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean HasItem(ItemStack database, int id) {
        return MatterDatabaseHelper.HasItem(database.func_77978_p(), id);
    }

    public static boolean HasItem(NBTTagCompound tagcompound, int id) {
        NBTTagCompound items;
        if (tagcompound != null && (items = tagcompound) != null) {
            NBTTagList itemList = items.func_150295_c(ITEMS_TAG_NAME, 10);
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (itemList.func_150305_b(i).func_74765_d("id") != id) continue;
                return true;
            }
        }
        return false;
    }

    public static int GetProgressFromNBT(NBTTagCompound itemNBT) {
        if (itemNBT != null) {
            return itemNBT.func_74771_c(PROGRESS_TAG_NAME);
        }
        return 0;
    }

    public static void SetProgressToNBT(NBTTagCompound itemNBT, byte amount) {
        if (itemNBT != null) {
            itemNBT.func_74774_a(PROGRESS_TAG_NAME, amount);
        }
    }

    public static int GetItemProgress(ItemStack storage, ItemStack item) {
        NBTTagCompound tag = MatterDatabaseHelper.GetItemAsNBT(storage, item);
        if (tag != null && tag.func_74764_b(PROGRESS_TAG_NAME)) {
            return tag.func_74771_c(PROGRESS_TAG_NAME);
        }
        return -1;
    }

    public static void writeToNBT(ItemStack patternStorage, ItemStack item, int progress) {
        NBTTagCompound itemNBT;
        if (!patternStorage.func_77942_o()) {
            MatterDatabaseHelper.InitItemListTagCompound(patternStorage);
        }
        if ((itemNBT = MatterDatabaseHelper.GetItemAsNBT(patternStorage, item)) != null) {
            byte lastProgress = itemNBT.func_74771_c(PROGRESS_TAG_NAME);
            int newProgress = MathHelper.clampI((int)(lastProgress + progress), (int)0, (int)100);
            itemNBT.func_74774_a(PROGRESS_TAG_NAME, (byte)newProgress);
            System.out.println("Item in list");
        } else {
            NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(patternStorage);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(PROGRESS_TAG_NAME, (byte)progress);
            MatterDatabaseHelper.writeStackToNBT(item, nbttagcompound1);
            itemList.func_74742_a((NBTBase)nbttagcompound1);
        }
    }

    public static void writeStackToNBT(ItemStack itemStack, NBTTagCompound tagCompound) {
        if (itemStack != null && tagCompound != null) {
            itemStack.func_77955_b(tagCompound);
            tagCompound.func_74774_a("Count", (byte)1);
        }
    }

    public static ItemStack GetItemWithInfo(ItemStack scanner, int id) {
        NBTTagCompound itemCompound = MatterDatabaseHelper.GetItemAsNBT(scanner, id);
        ItemStack item = MatterDatabaseHelper.GetItem(scanner, id);
        if (item != null && itemCompound != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(PROGRESS_TAG_NAME, itemCompound.func_74771_c(PROGRESS_TAG_NAME));
            item.func_77982_d(tag);
            return item;
        }
        return null;
    }

    public static ItemStack GetItem(ItemStack scanner, ItemStack item) {
        return MatterDatabaseHelper.GetItemStackFromNBT(MatterDatabaseHelper.GetItemAsNBT(scanner, item));
    }

    public static ItemStack GetItem(ItemStack scanner, int id) {
        return MatterDatabaseHelper.GetItemStackFromNBT(MatterDatabaseHelper.GetItemAsNBT(scanner, id));
    }

    public static ItemStack GetItem(ItemStack scanner, String id) {
        return MatterDatabaseHelper.GetItemStackFromNBT(MatterDatabaseHelper.GetItemAsNBT(scanner, id));
    }

    public static ItemStack GetItemStackFromNBT(NBTTagCompound comp) {
        if (comp != null) {
            return ItemStack.func_77949_a((NBTTagCompound)comp);
        }
        return null;
    }

    public static ItemStack GetItemAt(ItemStack scanner, int index) {
        return MatterDatabaseHelper.GetItemStackFromNBT(MatterDatabaseHelper.GetItemAsNBTAt(scanner, index));
    }

    public static NBTTagCompound GetItemAsNBT(ItemStack patternStorage, ItemStack item) {
        NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(patternStorage);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            if (!MatterDatabaseHelper.areEqual(item, MatterDatabaseHelper.GetItemStackFromNBT(itemList.func_150305_b(i)))) continue;
            return MatterDatabaseHelper.GetItemAsNBTAt(patternStorage, i);
        }
        return null;
    }

    public static NBTTagCompound GetItemAsNBT(ItemStack patternStorage, int id) {
        NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(patternStorage);
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (itemList.func_150305_b(i).func_74765_d("id") != id) continue;
                return MatterDatabaseHelper.GetItemAsNBTAt(patternStorage, i);
            }
        }
        return null;
    }

    public static NBTTagCompound GetItemAsNBT(ItemStack patternStorage, String id) {
        NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(patternStorage);
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (!MatterDatabaseHelper.GetItemStackFromNBT(itemList.func_150305_b(i)).func_77977_a().equalsIgnoreCase(id)) continue;
                return MatterDatabaseHelper.GetItemAsNBTAt(patternStorage, i);
            }
        }
        return null;
    }

    private static NBTTagCompound GetItemAsNBTAt(ItemStack patternStorage, int index) {
        NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(patternStorage);
        if (itemList != null && index < itemList.func_74745_c()) {
            return itemList.func_150305_b(index);
        }
        return null;
    }

    public static int GetIndexOfItem(ItemStack scanner, Block block) {
        ItemStack item = new ItemStack(block);
        return MatterDatabaseHelper.GetIndexOfItem(scanner, item);
    }

    public static int GetIndexOfItem(ItemStack scanner, World world, int x, int y, int z) {
        ItemStack item = MatterDatabaseHelper.GetItemStackFromWorld(world, x, y, z);
        return MatterDatabaseHelper.GetIndexOfItem(scanner, item);
    }

    public static int GetIndexOfItem(ItemStack scanner, ItemStack item) {
        NBTTagList itemList = MatterDatabaseHelper.GetItemsTagList(scanner);
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (!MatterDatabaseHelper.areEqual(item, MatterDatabaseHelper.GetItemStackFromNBT(itemList.func_150305_b(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean areEqual(ItemStack one, ItemStack two) {
        if (one != null && two != null && one.func_77973_b() == two.func_77973_b()) {
            if (one.func_77981_g() && two.func_77981_g()) {
                if (one.func_77960_j() == two.func_77960_j()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(NBTTagCompound one, NBTTagCompound two) {
        if (one == null || two == null) {
            return false;
        }
        return MatterDatabaseHelper.areEqual(ItemStack.func_77949_a((NBTTagCompound)one), ItemStack.func_77949_a((NBTTagCompound)two));
    }

    public static NBTTagList GetItemsTagList(ItemStack patternStorage) {
        if (patternStorage.func_77973_b() instanceof IMatterPatternStorage) {
            return ((IMatterPatternStorage)patternStorage.func_77973_b()).getItemsAsNBT(patternStorage);
        }
        return null;
    }

    public static ItemStack GetItemStackFromWorld(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b != null && Item.func_150898_a((Block)b) != null) {
            int meta = world.func_72805_g(x, y, z);
            return new ItemStack(b, 1, b.func_149692_a(meta));
        }
        return new ItemStack(b);
    }

    public static EnumChatFormatting getPatternInfoColor(int progress) {
        EnumChatFormatting color = EnumChatFormatting.GRAY;
        color = progress > 0 && progress <= 20 ? EnumChatFormatting.RED : (progress > 20 && progress <= 40 ? EnumChatFormatting.GOLD : (progress > 40 && progress <= 60 ? EnumChatFormatting.YELLOW : (progress > 40 && progress <= 80 ? EnumChatFormatting.AQUA : (progress > 80 && progress <= 100 ? EnumChatFormatting.GREEN : EnumChatFormatting.GREEN))));
        return color;
    }
}

