/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cofh.lib.util.helpers.MathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import matteroverdrive.api.inventory.UpgradeTypes;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class MOStringHelper {
    public static final String MORE_INFO = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY + "Hold " + EnumChatFormatting.ITALIC + EnumChatFormatting.YELLOW + "Shift" + EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY + " for Details.";
    private static String[] suffix = new String[]{"", "K", "M", "B", "T"};
    private static int MAX_LENGTH = 4;

    public static String formatNUmber(double number) {
        if (number > 1.0E15) {
            return new DecimalFormat("0.00Q").format(number / 1.0E15);
        }
        if (number > 1.0E12) {
            return new DecimalFormat("0.00T").format(number / 1.0E12);
        }
        if (number > 1.0E9) {
            return new DecimalFormat("0.00B").format(number / 1.0E9);
        }
        if (number > 1000000.0) {
            return new DecimalFormat("0.00M").format(number / 1000000.0);
        }
        if (number > 1000.0) {
            return new DecimalFormat("0.00K").format(number / 1000.0);
        }
        return String.valueOf(number);
    }

    public static String formatRemainingTime(float seccounds) {
        if (seccounds > 3600.0f) {
            return String.format("%s hr", String.valueOf(Math.round(seccounds / 3600.0f)));
        }
        if (seccounds > 60.0f && seccounds < 3600.0f) {
            return String.format("%s min", String.valueOf(Math.round(seccounds / 60.0f)));
        }
        return String.format("%s sec", String.valueOf(Math.round(seccounds)));
    }

    public static String typingAnimation(String message, int time, int maxTime) {
        float percent = (float)time / (float)maxTime;
        int messageCount = message.length();
        return message.substring(0, MathHelper.clampI((int)Math.round((float)messageCount * percent), (int)0, (int)messageCount));
    }

    public static boolean hasTranslation(String string) {
        return StatCollector.func_94522_b((String)string);
    }

    public static String translateToLocal(String string) {
        return StatCollector.func_74838_a((String)string);
    }

    public static String translateToLocal(UpgradeTypes type) {
        return StatCollector.func_74838_a((String)("upgradetype." + type.name() + ".name"));
    }

    public static String weaponStatTranslateToLocal(int type) {
        return StatCollector.func_74838_a((String)("weaponstat." + type + ".name"));
    }

    public static String toInfo(UpgradeTypes type, double value, boolean good) {
        String info = "";
        info = good ? info + EnumChatFormatting.GREEN : info + EnumChatFormatting.RED;
        DecimalFormat format = new DecimalFormat("##");
        info = info + MOStringHelper.translateToLocal(type) + ": ";
        info = info + format.format(value * 100.0);
        return info + "%";
    }

    public static String weaponStatToInfo(int type, double value, boolean good) {
        String info = "";
        info = good ? info + EnumChatFormatting.GREEN : info + EnumChatFormatting.RED;
        DecimalFormat format = new DecimalFormat("##");
        info = info + MOStringHelper.weaponStatTranslateToLocal(type) + ": ";
        info = info + format.format(value * 100.0);
        return info + "%";
    }

    public static String toInfo(UpgradeTypes type, double value) {
        return MOStringHelper.toInfo(type, value, MOStringHelper.getGood(type, value));
    }

    public static String weaponStatToInfo(int type, double value) {
        return MOStringHelper.weaponStatToInfo(type, value, MOStringHelper.weaponStatGetGood(type, value));
    }

    public static boolean getGood(UpgradeTypes type, double value) {
        switch (type) {
            case Speed: {
                return value < 1.0;
            }
            case PowerUsage: {
                return value < 1.0;
            }
            case Fail: {
                return value < 1.0;
            }
        }
        return value >= 1.0;
    }

    public static String readTextFile(ResourceLocation location) {
        StringBuilder text = new StringBuilder();
        try {
            String line;
            String path = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            InputStream descriptionStream = MOStringHelper.class.getResourceAsStream(path);
            LineNumberReader descriptionReader = new LineNumberReader(new InputStreamReader(descriptionStream));
            while ((line = descriptionReader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    public static String addPrefix(String name, String prefix) {
        if (prefix.endsWith("-")) {
            return prefix.substring(0, prefix.length() - 2) + Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return prefix + " " + name;
    }

    public static String addSuffix(String name, String suffix) {
        if (suffix.startsWith("-")) {
            return name + suffix.substring(1);
        }
        return name + " " + suffix;
    }

    public static boolean weaponStatGetGood(int type, double value) {
        switch (type) {
            case 8: {
                return value > 0.0;
            }
        }
        return value >= 1.0;
    }
}

