/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MOPhysicsHelper {
    public static boolean insideBounds(Vec3 pos, AxisAlignedBB bounds) {
        return bounds.field_72340_a <= pos.field_72450_a && bounds.field_72338_b <= pos.field_72448_b && bounds.field_72339_c <= pos.field_72449_c && bounds.field_72336_d >= pos.field_72450_a && bounds.field_72337_e >= pos.field_72448_b && bounds.field_72334_f >= pos.field_72449_c;
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3 offset) {
        return MOPhysicsHelper.rayTrace(viewer, world, distance, ticks, offset, false, false);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3 offset, boolean checkBlockCollision, boolean onlySolid) {
        return MOPhysicsHelper.rayTrace(viewer, world, distance, ticks, offset, checkBlockCollision, onlySolid, null);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase viewer, World world, double distance, float ticks, Vec3 offset, boolean checkBlockCollision, boolean onlySolid, Vec3 dir) {
        return MOPhysicsHelper.rayTrace(MOPhysicsHelper.getPosition(viewer, ticks), world, distance, ticks, offset, checkBlockCollision, onlySolid, dir, viewer);
    }

    public static MovingObjectPosition rayTrace(Vec3 fromPos, World world, double distance, float ticks, Vec3 offset, boolean checkBlockCollision, boolean onlySolid, Vec3 dir, EntityLivingBase viewer) {
        MovingObjectPosition objectMouseOver = null;
        Entity pointedEntity = null;
        if (world != null) {
            if (dir == null) {
                dir = viewer.func_70676_i(ticks);
            }
            double d0 = distance;
            objectMouseOver = MOPhysicsHelper.rayTraceForBlocks(fromPos, world, d0, ticks, offset, checkBlockCollision, onlySolid, dir);
            double d1 = d0;
            Vec3 vec3 = fromPos;
            if (offset != null) {
                vec3 = vec3.func_72441_c(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            if (objectMouseOver != null) {
                d1 = objectMouseOver.field_72307_f.func_72438_d(vec3);
            }
            Vec3 vec32 = vec3.func_72441_c(dir.field_72450_a * d0, dir.field_72448_b * d0, dir.field_72449_c * d0);
            Vec3 vec33 = null;
            float f1 = 1.0f;
            List list = world.func_72839_b((Entity)viewer, viewer.field_70121_D.func_72321_a(dir.field_72450_a * d0, dir.field_72448_b * d0, dir.field_72449_c * d0).func_72314_b((double)f1, (double)f1, (double)f1));
            double d2 = d1;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70067_L()) continue;
                float f2 = entity.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
                if (axisalignedbb.func_72318_a(vec3)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    pointedEntity = entity;
                    vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                vec33 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && d2 < d1) {
                if (objectMouseOver != null) {
                    objectMouseOver.field_72313_a = MovingObjectPosition.MovingObjectType.ENTITY;
                    objectMouseOver.field_72308_g = pointedEntity;
                    objectMouseOver.field_72307_f = vec33;
                } else {
                    objectMouseOver = new MovingObjectPosition(pointedEntity, vec33);
                    objectMouseOver.field_72311_b = (int)vec33.field_72450_a;
                    objectMouseOver.field_72312_c = (int)vec33.field_72448_b;
                    objectMouseOver.field_72309_d = (int)vec33.field_72449_c;
                }
            }
        }
        return objectMouseOver;
    }

    public static MovingObjectPosition rayTraceForBlocks(EntityLivingBase viewer, World world, double distance, float ticks, Vec3 offset, boolean collisionCheck, boolean onlySolid) {
        return MOPhysicsHelper.rayTraceForBlocks(viewer, world, distance, ticks, offset, collisionCheck, onlySolid, null);
    }

    public static MovingObjectPosition rayTraceForBlocks(EntityLivingBase viewer, World world, double distance, float ticks, Vec3 offset, boolean collisionCheck, boolean onlySolid, Vec3 dir) {
        return MOPhysicsHelper.rayTraceForBlocks(MOPhysicsHelper.getPosition(viewer, ticks), world, distance, ticks, offset, collisionCheck, onlySolid, dir == null ? viewer.func_70676_i(ticks) : dir);
    }

    public static MovingObjectPosition rayTraceForBlocks(Vec3 fromPosition, World world, double distance, float ticks, Vec3 offset, boolean collisionCheck, boolean onlySolid, Vec3 dir) {
        Vec3 vec3 = Vec3.func_72443_a((double)fromPosition.field_72450_a, (double)fromPosition.field_72448_b, (double)fromPosition.field_72449_c);
        if (offset != null) {
            vec3 = vec3.func_72441_c(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        }
        Vec3 vec31 = dir;
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * distance, vec31.field_72448_b * distance, vec31.field_72449_c * distance);
        return world.func_147447_a(vec3, vec32, collisionCheck, onlySolid, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition mouseRaytraceForBlocks(int mouseX, int mouseY, int width, int height, EntityLivingBase viewer, World world, boolean collisionCheck, boolean onlySolid) {
        Vec3 dir = MOMathHelper.mouseToWorldRay(mouseX, mouseY, width, height);
        Vec3 vec3 = viewer.func_70666_h(1.0f);
        Vec3 vec32 = vec3.func_72441_c(dir.field_72450_a * 32.0, dir.field_72448_b * 32.0, dir.field_72449_c * 32.0);
        return world.func_147447_a(vec3, vec32, false, false, true);
    }

    public static Vec3 getPosition(EntityLivingBase entity, float p_70666_1_) {
        if (p_70666_1_ == 1.0f) {
            return Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        }
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)p_70666_1_;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)p_70666_1_;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)p_70666_1_;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }
}

