/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import cofh.lib.util.TimeTracker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.matter.IMatterConnection;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.data.MatterStorage;
import matteroverdrive.fluids.FluidMatterPlasma;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.tile.pipes.WeightedDirection;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityMatterPipe
extends TileEntityPipe
implements IMatterConnection,
IMatterHandler {
    public ForgeDirection lastDir = ForgeDirection.WEST;
    protected MatterStorage storage;
    public static Random rand = new Random();
    protected int transferSpeed = 10;
    TimeTracker t = new TimeTracker();
    @SideOnly(value=Side.CLIENT)
    private boolean matterVisible;

    public TileEntityMatterPipe() {
        this.storage = new MatterStorage(32);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.t.hasDelayPassed(this.field_145850_b, this.transferSpeed)) {
            this.Transfer();
        }
    }

    @Override
    public boolean canConnectTo(TileEntity entity, ForgeDirection direction) {
        if (entity != null && entity instanceof IFluidHandler) {
            return ((IFluidHandler)entity).canDrain(direction, (Fluid)MatterOverdriveFluids.matterPlasma) || ((IFluidHandler)entity).canFill(direction, (Fluid)MatterOverdriveFluids.matterPlasma);
        }
        return false;
    }

    public void Transfer() {
        if (this.getMatterStored() > 0) {
            List<WeightedDirection> validSides = this.getWeightedValidSides(this.lastDir);
            for (WeightedDirection dir : validSides) {
                if (this.getMatterStored() <= 0) {
                    return;
                }
                TileEntity e = this.field_145850_b.func_147438_o(this.field_145851_c + dir.dir.offsetX, this.field_145848_d + dir.dir.offsetY, this.field_145849_e + dir.dir.offsetZ);
                if (e == null || !(e instanceof IFluidHandler) || !((IFluidHandler)e).canFill(dir.dir, (Fluid)MatterOverdriveFluids.matterPlasma)) continue;
                IFluidHandler to = (IFluidHandler)e;
                int n = MatterHelper.Transfer(dir.dir, this.storage.getMaxExtract(), this, to);
            }
        }
    }

    private List<WeightedDirection> getWeightedValidSides(ForgeDirection transferDir) {
        int connections = this.getConnections();
        ArrayList<WeightedDirection> validSides = new ArrayList<WeightedDirection>(6);
        ForgeDirection transferDirOp = MatterHelper.opposite(transferDir);
        for (int i = 0; i < 6; ++i) {
            if (!MOMathHelper.getBoolean(connections, i)) continue;
            if (ForgeDirection.values()[i] == transferDir) {
                validSides.add(new WeightedDirection(ForgeDirection.values()[i], 2.0f));
                continue;
            }
            if (ForgeDirection.values()[i] == transferDirOp) {
                validSides.add(new WeightedDirection(ForgeDirection.values()[i], 0.0f));
                continue;
            }
            validSides.add(new WeightedDirection(ForgeDirection.values()[i], 0.5f + rand.nextFloat()));
        }
        if (validSides.size() > 1) {
            WeightedDirection.Sort(validSides);
        }
        return validSides;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories) {
        if (!this.field_145850_b.field_72995_K && categories.contains((Object)MachineNBTCategory.DATA)) {
            this.storage.writeToNBT(comp);
            comp.func_74774_a("transfer_dir", (byte)this.lastDir.ordinal());
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.storage.readFromNBT(comp);
            if (comp.func_74764_b("transfer_dir")) {
                this.lastDir = ForgeDirection.values()[comp.func_74771_c("transfer_dir")];
            }
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public boolean canConnectFrom(ForgeDirection dir) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean matterVisible() {
        return this.matterVisible;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean setMatterVisible(boolean matterVisible) {
        this.matterVisible = matterVisible;
        return this.matterVisible;
    }

    @Override
    public int getMatterStored() {
        return this.storage.getMatterStored();
    }

    @Override
    public int getMatterCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        int received = this.storage.receiveMatter(side, amount, simulate);
        if (!simulate && received > 0) {
            this.lastDir = side;
            this.t.markTime(this.field_145850_b);
        }
        return received;
    }

    @Override
    public int extractMatter(ForgeDirection direction, int amount, boolean simulate) {
        int matterExtracted = this.storage.extractMatter(direction, amount, simulate);
        if (!simulate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return matterExtracted;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("Connections", this.getConnections());
        tagCompound.func_74757_a("matterVisible", this.getMatterStored() > 0);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b.field_72995_K) {
            this.setMatterVisible(pkt.func_148857_g().func_74767_n("matterVisible"));
        }
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storage.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.storage.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storage.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.storage.getInfo()};
    }
}

