/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.api.starmap.IBuildable;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.server.starmap.PacketStarMapAttack;
import matteroverdrive.network.packet.server.starmap.PacketStarMapClientCommands;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.GalaxyServer;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MOStringHelper;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TileEntityMachineStarMap
extends MOTileEntityMachineEnergy
implements IWailaBodyProvider {
    GalacticPosition position = new GalacticPosition();
    GalacticPosition destination = new GalacticPosition();
    int zoomLevel;

    public TileEntityMachineStarMap() {
        super(0);
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        for (int i = 0; i < 4; ++i) {
            inventory.AddSlot(new Slot(false));
        }
        super.RegisterSlots(inventory);
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.getInventory() != this.inventory) {
            this.getInventory().func_70296_d();
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74774_a("ZoomLevel", (byte)this.zoomLevel);
            NBTTagCompound positionTag = new NBTTagCompound();
            NBTTagCompound destinationTag = new NBTTagCompound();
            this.position.writeToNBT(positionTag);
            this.destination.writeToNBT(destinationTag);
            nbt.func_74782_a("GalacticPosition", (NBTBase)positionTag);
            nbt.func_74782_a("GalacticDestination", (NBTBase)destinationTag);
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.zoomLevel = nbt.func_74771_c("ZoomLevel");
            this.position = new GalacticPosition(nbt.func_74775_l("GalacticPosition"));
            this.destination = new GalacticPosition(nbt.func_74775_l("GalacticDestination"));
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    public void zoom() {
        if (this.getZoomLevel() < this.getMaxZoom()) {
            this.setZoomLevel(this.getZoomLevel() + 1);
        } else {
            this.setZoomLevel(0);
        }
        this.ForceSync();
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 3));
    }

    @Override
    public IInventory getInventory() {
        if (this.getPlanet() != null) {
            return this.getPlanet();
        }
        return this.inventory;
    }

    public Planet getPlanet() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getPlanet(this.destination);
        }
        return GalaxyServer.getInstance().getPlanet(this.destination);
    }

    public Star getStar() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getStar(this.destination);
        }
        return GalaxyServer.getInstance().getStar(this.destination);
    }

    public Quadrant getQuadrant() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getQuadrant(this.destination);
        }
        return GalaxyServer.getInstance().getQuadrant(this.destination);
    }

    public int getMaxZoom() {
        if (this.getPlanet() != null) {
            return 4;
        }
        return 2;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            if (world.field_72995_K) {
                Planet homeworld = GalaxyClient.getInstance().getHomeworld((EntityPlayer)entityLiving);
                if (homeworld != null) {
                    this.position = new GalacticPosition(homeworld);
                }
            } else {
                Planet homeworld = GalaxyServer.getInstance().getHomeworld((EntityPlayer)entityLiving);
                if (homeworld != null) {
                    this.position = new GalacticPosition(homeworld);
                }
            }
            this.destination = new GalacticPosition(this.position);
            this.owner = ((EntityPlayer)entityLiving).func_146103_bH().getId();
        }
    }

    @Override
    public void onDestroyed() {
    }

    public GalacticPosition getGalaxyPosition() {
        return this.position;
    }

    public void setGalaxticPosition(GalacticPosition position) {
        this.position = position;
    }

    public void setDestination(GalacticPosition position) {
        this.destination = position;
    }

    public GalacticPosition getDestination() {
        return this.destination;
    }

    public SpaceBody getActiveSpaceBody() {
        switch (this.getZoomLevel()) {
            case 0: {
                return GalaxyClient.getInstance().getTheGalaxy();
            }
            case 1: {
                return GalaxyClient.getInstance().getQuadrant(this.destination);
            }
            case 2: {
                return GalaxyClient.getInstance().getStar(this.destination);
            }
        }
        return GalaxyClient.getInstance().getPlanet(this.destination);
    }

    public void SyncCommandsToServer() {
        if (this.field_145850_b.field_72995_K) {
            MatterOverdrive.packetPipeline.sendToServer(new PacketStarMapClientCommands(this));
        }
    }

    public void Attack(GalacticPosition from, GalacticPosition to, int shipID) {
        MatterOverdrive.packetPipeline.sendToServer(new PacketStarMapAttack(from, to, shipID));
    }

    public boolean isItemValidForSlot(int slot, ItemStack item, EntityPlayer player) {
        return (this.getPlanet() == null || this.getPlanet().isOwner(player)) && this.getInventory().func_94041_b(slot, item);
    }

    public void onItemPickup(EntityPlayer player, ItemStack itemStack) {
        if (!this.field_145850_b.field_72995_K && itemStack != null && itemStack.func_77973_b() instanceof IBuildable) {
            ((IBuildable)itemStack.func_77973_b()).setBuildStart(itemStack, this.func_145831_w().func_82737_E());
        }
    }

    public void onItemPlaced(ItemStack itemStack) {
        if (!this.field_145850_b.field_72995_K && itemStack != null && itemStack.func_77973_b() instanceof IBuildable) {
            ((IBuildable)itemStack.func_77973_b()).setBuildStart(itemStack, this.func_145831_w().func_82737_E());
        }
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof TileEntityMachineStarMap)) {
            throw new RuntimeException("Star Map WAILA provider is being used for something that is not a Star Map: " + te.getClass());
        }
        TileEntityMachineStarMap starMap = (TileEntityMachineStarMap)te;
        String[] levels = new String[]{"gui.tooltip.page.galaxy", "gui.tooltip.page.quadrant", "gui.tooltip.page.star", "gui.tooltip.page.planet", "gui.tooltip.page.planet_stats"};
        currenttip.add(String.format("%sCurrent Mode: %s%s (%d)", EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE, MOStringHelper.translateToLocal(levels[starMap.zoomLevel]), starMap.zoomLevel));
        return currenttip;
    }
}

