/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkBroadcaster;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentPatternMonitor;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.client.PacketPatternMonitorSync;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePatternMonitor
extends MOTileEntityMachine
implements IMatterNetworkDispatcher,
IMatterNetworkClient,
IMatterNetworkBroadcaster {
    public static final int BROADCAST_WEATING_DELAY = 80;
    public static final int SEARCH_DELAY = 120;
    public static final int VALIDATE_DELAY = 120;
    public static final int TASK_QUEUE_SIZE = 16;
    HashSet<BlockPosition> databases;
    MatterNetworkTaskQueue<MatterNetworkTaskReplicatePattern> taskQueue = new MatterNetworkTaskQueue(this, 16);
    TimeTracker searchDelayTracker;
    private MatterNetworkComponentPatternMonitor networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;

    public TileEntityMachinePatternMonitor() {
        super(4);
        this.databases = new HashSet();
        this.searchDelayTracker = new TimeTracker();
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new MatterNetworkComponentPatternMonitor(this);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        return this.networkComponent.onNetworkTick(world, phase);
    }

    public MatterNetworkTaskQueue<MatterNetworkTaskReplicatePattern> getTaskQueue(int id) {
        return this.taskQueue;
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }

    public void SyncDatabasesWithClient() {
        MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketPatternMonitorSync(this), this, 64.0);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.taskQueue.writeToNBT(nbt);
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.taskQueue.readFromNBT(nbt);
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public BlockPosition getPosition() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return BlockHelper.getOppositeSide((int)meta) == side.ordinal();
    }

    public void queuePatternRequest(NBTTagList request) {
        this.networkComponent.queuePatternRequest(request);
    }

    public HashSet<BlockPosition> getDatabases() {
        return this.databases;
    }

    public void setDatabases(HashSet<BlockPosition> blockPositions) {
        this.databases = blockPositions;
    }

    public void forceSearch(boolean refresh) {
        this.networkComponent.setNeedsSearchRefresh(refresh);
    }

    public void queueSearch() {
        if (this.searchDelayTracker.hasDelayPassed(this.field_145850_b, 120)) {
            this.forceSearch(true);
        }
    }

    public boolean needsRefresh() {
        return this.networkComponent.getNeedsSearchRefresh();
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return this.networkComponent.canPreform(packet);
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        this.networkComponent.queuePacket(packet, from);
    }

    public MatterNetworkPacketQueue getPacketQueue(int queueID) {
        return this.networkComponent.getPacketQueue(queueID);
    }

    @Override
    public int getPacketQueueCount() {
        return this.networkComponent.getPacketQueueCount();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public NBTTagCompound getFilter() {
        return this.componentMatterNetworkConfigs.getFilter();
    }

    public ComponentMatterNetworkConfigs getComponentMatterNetworkConfigs() {
        return this.componentMatterNetworkConfigs;
    }
}

