/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentQueue;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMachinePacketQueue
extends MOTileEntityMachine
implements IMatterNetworkClient {
    public static int BROADCAST_DELAY = 2;
    public static int TASK_QUEUE_SIZE = 16;
    protected MatterNetworkComponentQueue networkComponent;
    private BlockPosition[] connections = new BlockPosition[6];
    @SideOnly(value=Side.CLIENT)
    public int flashTime;

    public TileEntityMachinePacketQueue(int upgradeCount) {
        super(upgradeCount);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.networkComponent = new MatterNetworkComponentQueue(this);
        this.addComponent(this.networkComponent);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K && this.flashTime > 0) {
            --this.flashTime;
        }
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type.equals((Object)UpgradeTypes.Speed);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            for (int i = 0; i < this.connections.length; ++i) {
                TileEntity tileEntity;
                if (!nbt.func_74764_b("Connection" + i)) continue;
                BlockPosition position = new BlockPosition(nbt.func_74775_l("Connection" + i));
                if (this.field_145850_b == null || (tileEntity = position.getTileEntity(this.field_145850_b)) == null || !(tileEntity instanceof IMatterNetworkConnection)) continue;
                this.connections[i] = ((IMatterNetworkConnection)tileEntity).getPosition();
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.getConnection(i) == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                this.connections[i].writeToNBT(tagCompound);
                nbt.func_74782_a("Connection" + i, (NBTBase)tagCompound);
            }
        }
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        return this.networkComponent.onNetworkTick(world, phase);
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return this.networkComponent.canPreform(packet);
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        this.networkComponent.queuePacket(packet, from);
    }

    @Override
    public BlockPosition getPosition() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public MatterNetworkPacketQueue getPacketQueue(int queueID) {
        return this.networkComponent.getPacketQueue(queueID);
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    public BlockPosition getConnection(int id) {
        if (this.connections[id] != null) {
            if (this.connections[id].getTileEntity(this.field_145850_b) != null && this.connections[id].getTileEntity(this.field_145850_b) instanceof IMatterNetworkConnection) {
                return this.connections[id];
            }
            this.connections[id] = null;
            return null;
        }
        return this.connections[id];
    }

    public void setConnection(int id, BlockPosition position) {
        this.connections[id] = position;
    }

    public BlockPosition[] getConnections() {
        return this.connections;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 1024.0;
    }

    @Override
    public int getPacketQueueCount() {
        return this.networkComponent.getPacketQueueCount();
    }
}

