/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.tile.IMultiBlockTileEntity;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineChargingStation
extends MOTileEntityMachineEnergy
implements IMultiBlockTileEntity {
    public static final int ENERGY_CAPACITY = 512000;
    public static final int ENERGY_TRANSFER = 1024;
    public static int RANGE = 16;

    public TileEntityMachineChargingStation() {
        super(3);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(1024);
        this.energyStorage.setMaxReceive(1024);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageAndroidCharging();
    }

    private void manageAndroidCharging() {
        if (!this.field_145850_b.field_72995_K && this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
            AxisAlignedBB radius = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - RANGE), (double)(this.field_145848_d - RANGE), (double)(this.field_145849_e - RANGE), (double)(this.field_145851_c + RANGE), (double)(this.field_145848_d + RANGE), (double)(this.field_145849_e + RANGE));
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, radius);
            for (EntityPlayer player : players) {
                if (!AndroidPlayer.get(player).isAndroid()) continue;
                int required = this.getRequiredEnergy(player);
                int max = Math.min(this.getEnergyStored(ForgeDirection.UNKNOWN), 1024);
                int toExtract = Math.min(required, max);
                this.extractEnergy(ForgeDirection.UNKNOWN, AndroidPlayer.get(player).receiveEnergy(toExtract, false), false);
            }
        }
    }

    private int getRequiredEnergy(EntityPlayer player) {
        return (int)(1024.0 * (1.0 - MathHelper.func_151237_a((double)(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72444_a(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)).func_72433_c() / (double)RANGE), (double)0.0, (double)1.0)));
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    protected void onAwake(Side side) {
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 8192.0;
    }

    @Override
    public List<BlockPosition> getBoundingBlocks() {
        ArrayList<BlockPosition> coords = new ArrayList<BlockPosition>();
        coords.add(new BlockPosition(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
        coords.add(new BlockPosition(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e));
        return coords;
    }
}

