/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.api.tileentity.ITileInfo;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.MachineEnergyStorage;
import matteroverdrive.data.inventory.EnergySlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketPowerUpdate;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MOTileEntityMachineEnergy
extends MOTileEntityMachine
implements IEnergyHandler,
ITileInfo {
    protected MachineEnergyStorage energyStorage = new MachineEnergyStorage<MOTileEntityMachineEnergy>(this, 512);
    protected int energySlotID;

    public MOTileEntityMachineEnergy(int upgradeCount) {
        super(upgradeCount);
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.energySlotID = inventory.AddSlot(new EnergySlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.energyStorage.writeToNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.energyStorage.readFromNBT(nbt);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageCharging();
    }

    protected void manageCharging() {
        if (this.isCharging() && !this.field_145850_b.field_72995_K) {
            int emptyEnergySpace = this.getFreeEnergySpace(ForgeDirection.DOWN);
            int maxEnergyCanSpare = EnergyHelper.extractEnergyFromContainer((ItemStack)this.inventory.func_70301_a(this.energySlotID), (int)emptyEnergySpace, (boolean)true);
            if (emptyEnergySpace > 0 && maxEnergyCanSpare > 0) {
                this.receiveEnergy(ForgeDirection.DOWN, EnergyHelper.extractEnergyFromContainer((ItemStack)this.inventory.func_70301_a(this.energySlotID), (int)emptyEnergySpace, (boolean)false), false);
            }
        }
    }

    public boolean isCharging() {
        return this.inventory.func_70301_a(this.energySlotID) != null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory.func_70301_a(this.energySlotID)) && ((IEnergyContainerItem)this.inventory.func_70301_a(this.energySlotID).func_77973_b()).extractEnergy(this.inventory.func_70301_a(this.energySlotID), this.getFreeEnergySpace(ForgeDirection.DOWN), true) > 0;
    }

    public int getEnergySlotID() {
        return this.energySlotID;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int lastEnergy = this.energyStorage.getEnergyStored();
        int received = this.energyStorage.receiveEnergy(maxReceive, simulate);
        if (lastEnergy != this.energyStorage.getEnergyStored() && !simulate) {
            this.UpdateClientPower();
        }
        return received;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int lastEnergy = this.energyStorage.getEnergyStored();
        int extracted = this.energyStorage.extractEnergy(maxExtract, simulate);
        if (lastEnergy != this.energyStorage.getEnergyStored() && !simulate) {
            this.UpdateClientPower();
        }
        return extracted;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int GetEnergyStoredScaled(int i) {
        return MathHelper.ceil((double)((float)this.getEnergyStored(ForgeDirection.DOWN) / (float)this.energyStorage.getMaxEnergyStored() * (float)i));
    }

    public int getFreeEnergySpace(ForgeDirection dir) {
        return this.getMaxEnergyStored(dir) - this.getEnergyStored(dir);
    }

    public void setEnergyStored(int storage) {
        this.energyStorage.setEnergyStored(storage);
    }

    public void UpdateClientPower() {
        MatterOverdrive.packetPipeline.sendToAllAround(new PacketPowerUpdate(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (itemStack != null && itemStack.func_77942_o()) {
            this.energyStorage.readFromNBT(itemStack.func_77978_p());
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (itemStack != null && this.energyStorage.getEnergyStored() > 0) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.energyStorage.writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("MaxEnergy", this.energyStorage.getMaxEnergyStored());
            itemStack.func_77978_p().func_74768_a("PowerSend", this.energyStorage.getMaxExtract());
            itemStack.func_77978_p().func_74768_a("PowerReceive", this.energyStorage.getMaxReceive());
        }
    }

    public void getTileInfo(List<IChatComponent> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        info.add((IChatComponent)new ChatComponentText("Energy: " + MOEnergyHelper.formatEnergy(this.getEnergyStorage().getEnergyStored(), this.getEnergyStorage().getMaxEnergyStored())));
    }
}

