/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.util.MOLog;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TravelEvent {
    private long timeStart;
    private int timeLength;
    private GalacticPosition from;
    private GalacticPosition to;
    private ItemStack ship;

    public TravelEvent() {
    }

    public TravelEvent(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public TravelEvent(ByteBuf buf) {
        this.readFromBuffer(buf);
    }

    public TravelEvent(World world, GalacticPosition from, GalacticPosition to, ItemStack shipStack, Galaxy galaxy) {
        this.timeStart = world.func_82737_E();
        this.from = from;
        this.to = to;
        this.ship = shipStack;
        this.calculateTravelTime(galaxy, from, to);
    }

    private void calculateTravelTime(Galaxy galaxy, GalacticPosition from, GalacticPosition to) {
        this.timeLength = (int)((float)from.distanceToLY(galaxy, to) * 8.0f);
        if (this.timeLength == 0) {
            this.timeLength = (int)((float)from.distanceToAU(galaxy, to) * 10.0f);
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagCompound shipStackNBT = new NBTTagCompound();
        if (this.ship != null) {
            this.ship.func_77955_b(shipStackNBT);
            tagCompound.func_74782_a("Ship", (NBTBase)shipStackNBT);
        }
        tagCompound.func_74768_a("TimeLength", this.timeLength);
        tagCompound.func_74772_a("TimeStart", this.timeStart);
        tagCompound.func_74782_a("From", (NBTBase)this.from.toNBT());
        tagCompound.func_74782_a("To", (NBTBase)this.to.toNBT());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.from = new GalacticPosition(tagCompound.func_74775_l("From"));
        this.to = new GalacticPosition(tagCompound.func_74775_l("To"));
        if (tagCompound.func_150297_b("Ship", 10)) {
            try {
                this.ship = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Ship"));
            }
            catch (Exception e) {
                MOLog.warn("Could not load ship from NBT in travel event", e);
            }
        }
        this.timeLength = tagCompound.func_74762_e("TimeLength");
        this.timeStart = tagCompound.func_74763_f("TimeStart");
    }

    public void readFromBuffer(ByteBuf buf) {
        this.from = new GalacticPosition(buf);
        this.to = new GalacticPosition(buf);
        this.ship = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.timeLength = buf.readInt();
        this.timeStart = buf.readLong();
    }

    public void writeToBuffer(ByteBuf buf) {
        this.from.writeToBuffer(buf);
        this.to.writeToBuffer(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.ship);
        buf.writeInt(this.timeLength);
        buf.writeLong(this.timeStart);
    }

    public int getTimeLength() {
        return MathHelper.ceil((double)((float)this.timeLength * Galaxy.GALAXY_TRAVEL_TIME_MULTIPLY));
    }

    public void setTimeLength(int timeLength) {
        this.timeLength = timeLength;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public long getTimeRemainning(World world) {
        return this.timeStart + (long)this.getTimeLength() - world.func_82737_E();
    }

    public double getPercent(World world) {
        return 1.0 - (double)(this.timeStart + (long)this.timeLength - world.func_82737_E()) / (double)this.timeLength;
    }

    public void setTimeStart(long timeStart) {
        this.timeStart = timeStart;
    }

    public ItemStack getShip() {
        return this.ship;
    }

    public void setShip(ItemStack ship) {
        this.ship = ship;
    }

    public GalacticPosition getTo() {
        return this.to;
    }

    public void setTo(GalacticPosition to) {
        this.to = to;
    }

    public GalacticPosition getFrom() {
        return this.from;
    }

    public void setFrom(GalacticPosition from) {
        this.from = from;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean isValid(Galaxy galaxy) {
        if (this.from != null && this.to != null) {
            Planet from = galaxy.getPlanet(this.from);
            Planet to = galaxy.getPlanet(this.to);
            if (from != null && to != null) {
                return this.ship != null;
            }
        }
        return false;
    }

    public boolean isComplete(World world) {
        return this.timeStart + (long)this.timeLength - world.func_82737_E() <= 0L;
    }
}

