/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.starmap.GalaxyCommon;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Star;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class GalaxyClient
extends GalaxyCommon {
    private static GalaxyClient instance;

    public boolean canSeePlanetInfo(Planet planet, EntityPlayer player) {
        if (planet.isOwner(player)) {
            return true;
        }
        for (ItemStack shipStack : planet.getFleet()) {
            if (!((IShip)shipStack.func_77973_b()).isOwner(shipStack, player)) continue;
            return true;
        }
        return false;
    }

    public boolean canSeeStarInfo(Star star, EntityPlayer player) {
        for (Planet planet : star.getPlanets()) {
            if (!this.canSeePlanetInfo(planet, player)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && this.theGalaxy != null && !Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e.field_72995_K && Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g == 0 && event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71441_e != null) {
            this.theGalaxy.update((World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    public static GalaxyClient getInstance() {
        if (instance == null) {
            instance = new GalaxyClient();
        }
        return instance;
    }
}

