/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternMonitorCommands
extends TileEntityUpdatePacket {
    public static final int COMMAND_SEARCH = 0;
    public static final int COMMAND_REQUEST = 1;
    int command;
    NBTTagCompound data;

    public PacketPatternMonitorCommands() {
    }

    public PacketPatternMonitorCommands(TileEntityMachinePatternMonitor monitor, int command, NBTTagCompound data) {
        super(monitor);
        this.command = command;
        this.data = data;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.command = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.command);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketPatternMonitorCommands> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketPatternMonitorCommands message, MessageContext ctx) {
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity != null && entity instanceof TileEntityMachinePatternMonitor) {
                TileEntityMachinePatternMonitor monitor = (TileEntityMachinePatternMonitor)entity;
                if (message.command == 0) {
                    monitor.queueSearch();
                } else if (message.command == 1 && message.data != null) {
                    monitor.queuePatternRequest(message.data.func_150295_c("Requests", 10));
                }
            }
            return null;
        }
    }
}

