/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketMatterScannerUpdate
extends PacketAbstract {
    private NBTTagCompound selected;
    private short page;
    private short slot;

    public PacketMatterScannerUpdate() {
    }

    public PacketMatterScannerUpdate(ItemStack scanner, short slot) {
        this.selected = MatterScanner.getSelectedAsNBT(scanner);
        if (scanner.func_77942_o()) {
            this.page = scanner.func_77978_p().func_74771_c("page");
        }
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.selected = ByteBufUtils.readTag((ByteBuf)buf);
        this.page = buf.readShort();
        this.slot = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.selected);
        buf.writeShort((int)this.page);
        buf.writeShort((int)this.slot);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketMatterScannerUpdate> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketMatterScannerUpdate message, MessageContext ctx) {
            ItemStack scanner = player.field_71071_by.func_70301_a((int)message.slot);
            if (MatterHelper.isMatterScanner(scanner)) {
                MatterScanner.setSelected(scanner, message.selected);
                if (scanner.func_77942_o()) {
                    scanner.func_77978_p().func_74777_a("page", message.page);
                }
            }
            return null;
        }
    }
}

