/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayer;

public class PacketAndroidChangeAbility
extends PacketAbstract {
    String ability;

    public PacketAndroidChangeAbility() {
    }

    public PacketAndroidChangeAbility(String ability) {
        this.ability = ability;
    }

    public void fromBytes(ByteBuf buf) {
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ability);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketAndroidChangeAbility> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketAndroidChangeAbility message, MessageContext ctx) {
            AndroidPlayer androidPlayer;
            IBionicStat stat = MatterOverdrive.statRegistry.getStat(message.ability);
            if (stat != null && (androidPlayer = AndroidPlayer.get(player)).isUnlocked(stat, 0) && stat.showOnWheel(androidPlayer, androidPlayer.getUnlockedLevel(stat))) {
                androidPlayer.setActiveStat(stat);
                androidPlayer.sync(2);
            }
            return null;
        }
    }
}

