/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.bi;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.gui.GuiMatterScanner;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class PacketMatterScannerGetDatabase
extends TileEntityUpdatePacket {
    NBTTagList list;

    public PacketMatterScannerGetDatabase() {
    }

    public PacketMatterScannerGetDatabase(int x, int y, int z) {
        super(x, y, z);
    }

    public PacketMatterScannerGetDatabase(BlockPosition position) {
        this(position.x, position.y, position.z);
    }

    public PacketMatterScannerGetDatabase(NBTTagList list) {
        this.list = list;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        NBTTagCompound tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.list = tagCompound.func_150295_c("List", 10);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (this.list != null) {
            tagCompound.func_74782_a("List", (NBTBase)this.list);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    public static class Handler
    extends AbstractBiPacketHandler<PacketMatterScannerGetDatabase> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketMatterScannerGetDatabase message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof IMatterDatabase) {
                IMatterDatabase database = (IMatterDatabase)tileEntity;
                return new PacketMatterScannerGetDatabase(database.getItemsAsNBT());
            }
            return null;
        }

        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketMatterScannerGetDatabase message, MessageContext ctx) {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiMatterScanner) {
                GuiMatterScanner guiMatterScanner = (GuiMatterScanner)Minecraft.func_71410_x().field_71462_r;
                guiMatterScanner.UpdatePatternList(message.list);
            }
            return null;
        }
    }
}

