/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.tasks;

import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MatterNetworkTaskReplicatePattern
extends MatterNetworkTask {
    NBTTagCompound pattern;

    public MatterNetworkTaskReplicatePattern() {
    }

    public MatterNetworkTaskReplicatePattern(IMatterNetworkConnection sender, short itemID, short itemMetadata, byte amount) {
        super(sender);
        this.pattern = new NBTTagCompound();
        this.pattern.func_74777_a("id", itemID);
        this.pattern.func_74777_a("Damage", itemMetadata);
        this.pattern.func_74774_a("Count", amount);
    }

    public MatterNetworkTaskReplicatePattern(IMatterNetworkConnection sender, NBTTagCompound pattern) {
        super(sender);
        this.pattern = pattern;
    }

    @Override
    protected void init() {
        this.setUnlocalizedName("replicate_pattern");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound != null) {
            this.pattern = compound.func_74775_l("Pattern");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (compound != null) {
            compound.func_74782_a("Pattern", (NBTBase)this.pattern);
        }
    }

    @Override
    public String getName() {
        return this.pattern.func_74771_c("Count") + " " + MOStringHelper.translateToLocal(Item.func_150899_d((int)this.pattern.func_74765_d("id")).func_77658_a() + ".name");
    }

    public int getAmount() {
        return this.pattern.func_74771_c("Count");
    }

    public void setAmount(int amount) {
        this.pattern.func_74774_a("Count", (byte)amount);
    }

    public int getItemMetadata() {
        return this.pattern.func_74765_d("Damage");
    }

    public int getItemID() {
        return this.pattern.func_74765_d("id");
    }

    @Override
    public boolean isValid(World world) {
        if (!super.isValid(world)) {
            return false;
        }
        ItemStack stack = MatterDatabaseHelper.GetItemStackFromNBT(this.pattern);
        return MatterHelper.getMatterAmountFromItem(stack) > 0;
    }
}

