/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.packets;

import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.matter_network.MatterNetworkPacket;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkResponsePacket
extends MatterNetworkPacket {
    int responseType;
    int requestType;
    NBTTagCompound response;

    public MatterNetworkResponsePacket() {
    }

    public MatterNetworkResponsePacket(IMatterNetworkConnection sender, int responseType, int requestType, NBTTagCompound response, ForgeDirection port) {
        super(sender.getPosition(), port);
        this.responseType = responseType;
        this.requestType = requestType;
        this.response = response;
    }

    @Override
    public boolean isValid(World world) {
        return true;
    }

    @Override
    public String getName() {
        return "Response Packet";
    }

    public int getResponseType() {
        return this.responseType;
    }

    public boolean fits(int responseType, int requestType) {
        return this.getResponseType() == responseType && this.getRequestType() == requestType;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public NBTTagCompound getResponse() {
        return this.response;
    }
}

