/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cofh.lib.util.TimeTracker;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;
import matteroverdrive.tile.TileEntityMachinePatternStorage;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MatterNetworkComponentPatternStorage
extends MatterNetworkComponentClient<TileEntityMachinePatternStorage> {
    private TimeTracker taskProcessingTracker = new TimeTracker();

    public MatterNetworkComponentPatternStorage(TileEntityMachinePatternStorage patternStorage) {
        super(patternStorage);
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        if (packet instanceof MatterNetworkTaskPacket) {
            this.executeTasks((MatterNetworkTaskPacket)packet, ((MatterNetworkTaskPacket)packet).getTask(this.getWorldObj()));
        } else if (packet instanceof MatterNetworkRequestPacket) {
            this.executeBasicRequestPackets((MatterNetworkRequestPacket)packet);
            this.executeRequests((MatterNetworkRequestPacket)packet);
        }
    }

    protected void executeTasks(MatterNetworkTaskPacket packet, MatterNetworkTask task) {
        TileEntityMachinePatternStorage cfr_ignored_0 = (TileEntityMachinePatternStorage)this.rootClient;
        if (this.taskProcessingTracker.hasDelayPassed(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w(), 40) && task.getState().belowOrEqual(MatterNetworkTaskState.QUEUED) && task instanceof MatterNetworkTaskStorePattern) {
            if (((TileEntityMachinePatternStorage)this.rootClient).addItem(((MatterNetworkTaskStorePattern)task).getItemStack(), ((MatterNetworkTaskStorePattern)task).getProgress(), false, null)) {
                task.setState(MatterNetworkTaskState.FINISHED);
            } else {
                task.setState(MatterNetworkTaskState.WAITING);
            }
        }
    }

    protected void executeRequests(MatterNetworkRequestPacket packet) {
        if (packet.getRequestType() == 1) {
            int[] array;
            NBTTagCompound tagCompound;
            if (packet.getRequest() instanceof int[] && (tagCompound = ((TileEntityMachinePatternStorage)this.rootClient).getItemAsNBT(new ItemStack(Item.func_150899_d((int)(array = (int[])packet.getRequest())[0]), 1, array[1]))) != null && packet.getSender(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w()) instanceof IMatterNetworkClient) {
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, 1, tagCompound);
            }
        } else if (packet.getRequestType() == 3 && packet.getRequest() instanceof NBTTagCompound) {
            NBTTagCompound pattern = (NBTTagCompound)packet.getRequest();
            NBTTagCompound tagCompound = ((TileEntityMachinePatternStorage)this.rootClient).getItemAsNBT(ItemStack.func_77949_a((NBTTagCompound)pattern));
            if (tagCompound != null && MatterDatabaseHelper.GetProgressFromNBT(tagCompound) >= 100) {
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, 0, tagCompound);
            } else if (tagCompound == null || MatterDatabaseHelper.GetProgressFromNBT(tagCompound) < 100) {
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, 1, tagCompound);
            }
        }
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        if (super.canPreform(packet) && ((TileEntityMachinePatternStorage)this.rootClient).getRedstoneActive()) {
            if (packet instanceof MatterNetworkTaskPacket) {
                if (((MatterNetworkTaskPacket)packet).getTask(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w()) instanceof MatterNetworkTaskStorePattern) {
                    MatterNetworkTaskStorePattern task = (MatterNetworkTaskStorePattern)((MatterNetworkTaskPacket)packet).getTask(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w());
                    return ((TileEntityMachinePatternStorage)this.rootClient).addItem(task.getItemStack(), task.getProgress(), true, null);
                }
            } else if (packet instanceof MatterNetworkRequestPacket) {
                MatterNetworkRequestPacket requestPacket = (MatterNetworkRequestPacket)packet;
                return requestPacket.getRequestType() == 0 || requestPacket.getRequestType() == 1 || requestPacket.getRequestType() == 2 || requestPacket.getRequestType() == 3;
            }
        }
        return false;
    }
}

