/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cpw.mods.fml.common.gameevent.TickEvent;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.util.MOLog;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class MatterNetworkComponentClientDispatcher<K extends MatterNetworkTask, T extends MOTileEntityMachine & IMatterNetworkDispatcher>
extends MatterNetworkComponentClient<T>
implements IMatterNetworkDispatcher<K> {
    private TickEvent.Phase dispatchPhase;

    public MatterNetworkComponentClientDispatcher(T rootClient, TickEvent.Phase dispatchPhase) {
        super(rootClient);
        this.dispatchPhase = dispatchPhase;
    }

    @Override
    public MatterNetworkTaskQueue<K> getTaskQueue(int queueID) {
        return ((IMatterNetworkDispatcher)((Object)this.rootClient)).getTaskQueue(queueID);
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        super.onNetworkTick(world, phase);
        if (phase.equals((Object)this.dispatchPhase)) {
            for (int i = 0; i < this.getTaskQueueCount(); ++i) {
                if (this.getTaskQueue(i).peek() == null) continue;
                try {
                    return this.manageTopQueue(world, i, (MatterNetworkTask)this.getTaskQueue(i).peek());
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "Where was a problem while trying to get task from Queue from %s", this.getClass());
                }
            }
        }
        return 0;
    }

    public abstract int manageTopQueue(World var1, int var2, K var3);

    @Override
    public int getTaskQueueCount() {
        return ((IMatterNetworkDispatcher)((Object)this.rootClient)).getTaskQueueCount();
    }
}

