/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.data.Inventory;
import matteroverdrive.machines.IMachineComponent;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public abstract class MatterNetworkComponentClient<T extends MOTileEntityMachine>
implements IMatterNetworkClient,
IMachineComponent<T> {
    protected MatterNetworkPacketQueue<MatterNetworkPacket> packetQueue;
    protected T rootClient;

    public MatterNetworkComponentClient(T rootClient) {
        this.rootClient = rootClient;
        this.packetQueue = new MatterNetworkPacketQueue((IMatterNetworkConnection)rootClient);
    }

    public boolean executeBasicRequestPackets(MatterNetworkRequestPacket packet) {
        IMatterNetworkConnection sender = packet.getSender(this.getWorldObj());
        if (packet.getRequestType() == 2 || packet.getRequestType() == 0) {
            if (packet.getRequest() instanceof Class) {
                if (((Class)packet.getRequest()).isInstance(this.rootClient)) {
                    MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)this.rootClient, packet, 1, null);
                    return true;
                }
            } else {
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)this.rootClient, packet, 1, null);
                return true;
            }
        }
        return false;
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        if (this.canPreform(packet) && packet.isValid(this.getWorldObj())) {
            this.getPacketQueue(0).queue(packet);
            packet.tickAlive(this.getWorldObj(), true);
            packet.onAddedToQueue(this.getWorldObj(), this.getPacketQueue(0), 0);
        }
    }

    protected void manageTopPacket() {
        for (int i = 0; i < this.getPacketQueueCount(); ++i) {
            if (this.getPacketQueue(i).peek() == null) continue;
            try {
                this.executePacket((MatterNetworkPacket)this.getPacketQueue(i).peek());
                continue;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while executing packet %s from queue %s", this.getPacketQueue(i).peek(), i);
                continue;
            }
            finally {
                this.getPacketQueue(i).dequeue();
                this.getPacketQueue(i).tickAllAlive(this.getWorldObj(), true);
            }
        }
    }

    protected abstract void executePacket(MatterNetworkPacket var1);

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END) {
            this.manageTopPacket();
        }
        return 0;
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        if (packet.getFilter() != null) {
            NBTTagList connectionsList = packet.getFilter().func_150295_c("CONNECTIONS", 10);
            for (int i = 0; i < connectionsList.func_74745_c(); ++i) {
                BlockPosition filterPos = new BlockPosition(connectionsList.func_150305_b(i));
                if (!filterPos.equals(this.getPosition())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public BlockPosition getPosition() {
        return ((IMatterNetworkConnection)this.rootClient).getPosition();
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        return ((IMatterNetworkConnection)this.rootClient).canConnectFromSide(side);
    }

    @Override
    public MatterNetworkPacketQueue<MatterNetworkPacket> getPacketQueue(int queueID) {
        return this.packetQueue;
    }

    public World getWorldObj() {
        return this.rootClient.func_145831_w();
    }

    @Override
    public int getPacketQueueCount() {
        return 1;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.packetQueue.readFromNBT(nbt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.packetQueue.writeToNBT(nbt);
        }
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    @Override
    public void update(T machine) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onActiveChange(T machine) {
    }

    @Override
    public void onAwake(T machine, Side side) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving, T machine) {
    }
}

