/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network;

import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkQueue;
import matteroverdrive.matter_network.MatterNetworkRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MatterNetworkTaskQueue<T extends MatterNetworkTask>
extends MatterNetworkQueue<T> {
    public MatterNetworkTaskQueue(IMatterNetworkConnection connection, int capacity) {
        super("Tasks", connection, capacity);
    }

    public void drop() {
        for (MatterNetworkTask task : this.elements) {
            task.setState(MatterNetworkTaskState.INVALID);
        }
        this.elements.clear();
    }

    public T dropWithID(long id) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (((MatterNetworkTask)this.elements.get(i)).getId() != id) continue;
            return (T)((MatterNetworkTask)this.elements.remove(i));
        }
        return null;
    }

    public void tickAllAlive(World world, boolean alive) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((MatterNetworkTask)this.elements.get(i)).isValid(world)) continue;
            ((MatterNetworkTask)this.elements.get(i)).setAlive(alive);
        }
    }

    public T getWithID(long id) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (((MatterNetworkTask)this.elements.get(i)).getId() != id) continue;
            return (T)((MatterNetworkTask)this.elements.get(i));
        }
        return null;
    }

    @Override
    protected void readElementFromNBT(NBTTagCompound tagCompound, MatterNetworkTask element) {
        element.readFromNBT(tagCompound);
    }

    @Override
    protected void writeElementToNBT(NBTTagCompound tagCompound, MatterNetworkTask element) {
        element.writeToNBT(tagCompound);
        tagCompound.func_74768_a("Type", MatterNetworkRegistry.getTaskID(element.getClass()));
    }

    @Override
    protected Class getElementClassFromNBT(NBTTagCompound tagCompound) {
        return MatterNetworkRegistry.getTaskClass(tagCompound.func_74762_e("Type"));
    }
}

