/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.analyzer;

import cofh.api.energy.IEnergyStorage;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.network.IMatterNetworkBroadcaster;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DatabaseSlot;
import matteroverdrive.data.inventory.MatterSlot;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.analyzer.components.MatterNetworkComponentAnalyzer;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineMatterAnalyzer
extends MOTileEntityMachineEnergy
implements ISidedInventory,
IMatterNetworkDispatcher<MatterNetworkTaskStorePattern>,
IMatterNetworkClient,
IMatterNetworkBroadcaster {
    public static final int BROADCAST_DELAY = 60;
    public static final int BROADCAST_WEATING_DELAY = 2;
    public static final int VALID_LOCATION_CHECK_DELAY = 200;
    public static final int PROGRESS_AMOUNT_PER_ITEM = 20;
    public static final int ENERGY_STORAGE = 512000;
    public static final int ENERGY_TRANSFER = 512;
    public static final int ANALYZE_SPEED = 800;
    public static final int ENERGY_DRAIN_PER_ITEM = 64000;
    public int input_slot = 0;
    public int database_slot = 1;
    public int analyzeTime;
    private MatterNetworkTaskQueue<MatterNetworkTaskStorePattern> taskQueueSending;
    private MatterNetworkComponentAnalyzer networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;

    public TileEntityMachineMatterAnalyzer() {
        super(4);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(512);
        this.energyStorage.setMaxReceive(512);
        this.taskQueueSending = new MatterNetworkTaskQueue(this, 1);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public void RegisterSlots(Inventory inventory) {
        this.input_slot = inventory.AddSlot(new MatterSlot(true));
        this.database_slot = inventory.AddSlot(new DatabaseSlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new MatterNetworkComponentAnalyzer(this);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageAnalyze();
    }

    protected void manageAnalyze() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick() && this.networkComponent.getConnection() != null) {
                this.energyStorage.extractEnergy(this.getEnergyDrainPerTick(), false);
                if (this.analyzeTime < this.getSpeed()) {
                    ++this.analyzeTime;
                } else {
                    this.analyzeItem();
                    this.analyzeTime = 0;
                }
            }
            if (!this.isActive()) {
                this.analyzeTime = 0;
            }
        }
    }

    public boolean isAnalyzing() {
        if (this.getRedstoneActive() && this.inventory.getSlot(this.input_slot).getItem() != null) {
            if (this.inventory.getSlot(this.database_slot).getItem() != null) {
                return MatterHelper.getMatterAmountFromItem(this.inventory.func_70301_a(this.input_slot)) > 0 && this.hasConnectionToPatterns();
            }
            if (this.taskQueueSending.remaintingCapacity() > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean hasConnectionToPatterns() {
        NBTTagCompound itemAsNBT;
        IMatterDatabase database;
        return MatterHelper.isMatterScanner(this.inventory.func_70301_a(this.database_slot)) && (database = MatterScanner.getLink(this.field_145850_b, this.inventory.func_70301_a(this.database_slot))) != null && (database.hasItem(this.inventory.func_70301_a(this.input_slot)) ? (itemAsNBT = database.getItemAsNBT(this.inventory.func_70301_a(this.input_slot))) != null && MatterDatabaseHelper.GetProgressFromNBT(itemAsNBT) < 100 : MatterDatabaseHelper.getFirstFreePatternStorage(database) != null);
    }

    public void analyzeItem() {
        ItemStack scanner = this.inventory.func_70301_a(this.database_slot);
        ItemStack itemStack = this.inventory.func_70301_a(this.input_slot);
        IMatterDatabase database = null;
        if (scanner != null && MatterHelper.isMatterScanner(scanner)) {
            database = MatterScanner.getLink(this.field_145850_b, scanner);
        }
        if (database != null) {
            if (database.addItem(itemStack, 20, false, null)) {
                SoundHandler.PlaySoundAt(this.field_145850_b, "scanner_success", this.field_145851_c, (float)this.field_145848_d, (float)this.field_145849_e);
            } else {
                MatterNetworkTaskStorePattern storePattern = new MatterNetworkTaskStorePattern(this, itemStack, 20);
                storePattern.setState(MatterNetworkTaskState.WAITING);
                this.taskQueueSending.queue(storePattern);
            }
        } else {
            MatterNetworkTaskStorePattern storePattern = new MatterNetworkTaskStorePattern(this, itemStack, 20);
            storePattern.setState(MatterNetworkTaskState.WAITING);
            this.taskQueueSending.queue(storePattern);
        }
        this.func_70298_a(this.input_slot, 1);
        this.forceClientUpdate = true;
        this.func_70296_d();
        this.networkComponent.resetValidLocation();
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerUsage || type == UpgradeTypes.PowerStorage || type == UpgradeTypes.Fail || type == UpgradeTypes.Output || type == UpgradeTypes.Speed;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tagCompound, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(tagCompound, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.analyzeTime = tagCompound.func_74765_d("AnalyzeTime");
            this.taskQueueSending.readFromNBT(tagCompound);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tagCompound, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(tagCompound, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            tagCompound.func_74777_a("AnalyzeTime", (short)this.analyzeTime);
            this.taskQueueSending.writeToNBT(tagCompound);
        }
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{this.input_slot, this.database_slot};
        }
        return new int[]{this.input_slot};
    }

    @Override
    public BlockPosition getPosition() {
        return new BlockPosition((TileEntity)this);
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return BlockHelper.getOppositeSide((int)meta) == side.ordinal();
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        return this.networkComponent.onNetworkTick(world, phase);
    }

    @Override
    public MatterNetworkTaskQueue<MatterNetworkTaskStorePattern> getTaskQueue(int id) {
        return this.taskQueueSending;
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return this.networkComponent.canPreform(packet);
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        this.networkComponent.queuePacket(packet, from);
    }

    @Override
    public MatterNetworkPacketQueue<MatterNetworkPacket> getPacketQueue(int queueID) {
        return this.networkComponent.getPacketQueue(queueID);
    }

    @Override
    public int getPacketQueueCount() {
        return this.networkComponent.getPacketQueueCount();
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void onActiveChange() {
        this.ForceSync();
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getSpeed() {
        return MathHelper.round((double)(800.0 * this.getUpgradeMultiply(UpgradeTypes.Speed)));
    }

    public int getEnergyDrainPerTick() {
        return this.getEnergyDrainMax() / this.getSpeed();
    }

    public int getEnergyDrainMax() {
        return MathHelper.round((double)(64000.0 * this.getUpgradeMultiply(UpgradeTypes.PowerUsage)));
    }

    @Override
    public boolean getServerActive() {
        return this.isAnalyzing();
    }

    @Override
    public String getSound() {
        return "analyzer";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 0.3f;
    }

    @Override
    public NBTTagCompound getFilter() {
        return this.componentMatterNetworkConfigs.getFilter();
    }

    @Override
    public float getProgress() {
        return (float)this.analyzeTime / (float)this.getSpeed();
    }
}

