/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.client.render.item.ItemRendererPhaserRifle;
import matteroverdrive.entity.weapon.PhaserFire;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.server.PacketFirePhaserRifle;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class PhaserRifle
extends EnergyWeapon {
    private static final int HEAT_PER_SHOT = 20;
    private static final int MAX_HEAT = 80;
    private static final int MAX_USE_TIME = 512;
    private static final int ENERGY_PER_SHOT = 1024;
    public static final int RANGE = 24;

    public PhaserRifle(String name) {
        super(name, 32000, 128, 128, 24);
        this.field_77789_bW = true;
    }

    public void func_94581_a(IIconRegister iconRegistry) {
    }

    public int func_77626_a(ItemStack item) {
        return 512;
    }

    @Override
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 4: {
                return new Vector2f(205.0f, 80.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 35.0f);
            }
        }
        return new Vector2f(0.0f, 0.0f);
    }

    @Override
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 80.0f);
            }
            case 1: {
                return new Vector2f(100.0f, 80.0f);
            }
            case 2: {
                return new Vector2f(90.0f, 90.0f);
            }
            case 3: {
                return new Vector2f(140.0f, 72.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        player.func_71008_a(item, Integer.MAX_VALUE);
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return item;
    }

    @Override
    public boolean onLeftClick(ItemStack weapon, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return true;
    }

    @Override
    public int getShootCooldown() {
        return 11;
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (world.field_72995_K && entity instanceof EntityClientPlayerMP && ((EntityPlayer)entity).func_70694_bm() != null && ((EntityPlayer)entity).func_70694_bm().func_77973_b() == this && Minecraft.func_71410_x().field_71462_r == null && Mouse.isButtonDown((int)0)) {
            if (this.canFire(itemStack, world) && ClientProxy.weaponHandler.shootDelayPassed(this)) {
                int seed = field_77697_d.nextInt();
                itemStack.func_77978_p().func_74772_a("LastShot", world.func_82737_E());
                ItemRendererPhaserRifle.RECOIL_AMOUNT = Mouse.isButtonDown((int)1) ? 0.5f + this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 3.0f : 2.0f + this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 6.0f;
                ItemRendererPhaserRifle.RECOIL_TIME = 1.0f;
                Vec3 dir = ((EntityPlayer)entity).func_70676_i(1.0f);
                Vec3 pos = this.getFirePosition((EntityPlayer)entity, dir, Mouse.isButtonDown((int)1));
                this.onClientFire(itemStack, (EntityPlayer)entity, Mouse.isButtonDown((int)1), seed, pos, dir);
                MatterOverdrive.packetPipeline.sendToServer(new PacketFirePhaserRifle(Mouse.isButtonDown((int)1), entity.func_145782_y(), seed, pos, dir));
                ClientProxy.weaponHandler.addShootDelay(this);
            } else if (ClientProxy.weaponHandler.shootDelayPassed(this) && this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, (EntityPlayer)entity);
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3 getFirePosition(EntityPlayer entityPlayer, Vec3 dir, boolean isAiming) {
        Vec3 pos = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v);
        if (!isAiming) {
            pos.field_72450_a -= (double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            pos.field_72449_c -= (double)(MathHelper.func_76126_a((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityPlayer entityPlayer, boolean zoomed, int seed, int latency, Vec3 position, Vec3 dir) {
        this.DrainEnergy(weapon, 1, false);
        float newHeat = (this.getHeat(weapon) + 4.0f) * 2.0f;
        this.setHeat(weapon, newHeat);
        this.manageOverheat(weapon, entityPlayer.field_70170_p, entityPlayer);
        PhaserFire fire = this.spawnProjectile(weapon, entityPlayer, position, dir, zoomed, seed);
        weapon.func_77978_p().func_74772_a("LastShot", entityPlayer.field_70170_p.func_82737_E());
        fire.simulate(latency);
        entityPlayer.func_85030_a("mo:phaser_rifle_shot", 0.3f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        return true;
    }

    public void onClientFire(ItemStack weapon, EntityPlayer player, boolean zoomed, int seed, Vec3 position, Vec3 dir) {
        player.func_85030_a("mo:phaser_rifle_shot", 0.3f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        this.spawnProjectile(weapon, player, position, dir, zoomed, seed);
    }

    public PhaserFire spawnProjectile(ItemStack weapon, EntityPlayer entityPlayer, Vec3 position, Vec3 dir, boolean zoomed, int seed) {
        PhaserFire fire = new PhaserFire(entityPlayer.field_70170_p, (EntityLivingBase)entityPlayer, position, dir, this.getWeaponScaledDamage(weapon), 2.0f, this.getAccuracy(weapon, zoomed), this.getRange(weapon), WeaponHelper.getColor(weapon).getColor(), zoomed, seed);
        if (WeaponHelper.hasStat(4, weapon)) {
            fire.setFireDamageMultiply((float)WeaponHelper.getStatMultiply(4, weapon));
        }
        entityPlayer.field_70170_p.func_72838_d((Entity)fire);
        return fire;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemStack) {
        return itemStack.func_77960_j() == 1 ? EnumAction.bow : EnumAction.none;
    }

    @Override
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        return 1024;
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 3.0f;
    }

    @Override
    public boolean canFire(ItemStack weapon, World world) {
        return this.DrainEnergy(weapon, 1, true) && !weapon.func_77978_p().func_74767_n("Overheated");
    }

    public float getAccuracy(ItemStack weapon, boolean zoomed) {
        return this.getHeat(weapon) / (zoomed ? 30.0f : 10.0f);
    }
}

