/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.sound.PhaserSound;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Vector2f;

public class Phaser
extends EnergyWeapon
implements IWeapon {
    private static final double ENERGY_MULTIPLY = 2.5;
    private static final int MAX_USE_TIME = 60;
    private static final int MAX_HEAT = 80;
    public static final int MAX_LEVEL = 6;
    private static final int KILL_MODE_LEVEL = 3;
    private static final float KILL_DAMAGE_MULTIPLY = 2.5f;
    private static final int STUN_SLEEP_MULTIPLY = 5;
    public static final int RANGE = 24;
    Map<EntityPlayer, PhaserSound> soundMap;

    public Phaser(String name) {
        super(name, 32000, 128, 128, 24);
        this.field_77789_bW = true;
        this.soundMap = new HashMap<EntityPlayer, PhaserSound>();
    }

    public void func_94581_a(IIconRegister iconRegistry) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        return (int)Math.pow(2.5, level + 1);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
        infos.add(EnumChatFormatting.BLUE + "Stun: " + (float)this.GetSleepTime(weapon) / 20.0f + "s");
    }

    public int func_77626_a(ItemStack item) {
        return 60;
    }

    public static boolean isKillMode(ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74771_c("power") >= 3;
    }

    private void ManageShooting(ItemStack item, World w, EntityPlayer player) {
        if (w.field_72995_K) {
            return;
        }
        Vec3 dir = this.getPlayerLook(player, item);
        MovingObjectPosition hit = MOPhysicsHelper.rayTrace((EntityLivingBase)player, w, this.getRange(item), 0.0f, Vec3.func_72443_a((double)0.0, (double)player.func_70047_e(), (double)0.0), false, true, dir);
        if (hit != null) {
            int z;
            int y;
            int x;
            Vec3 hitVector = hit.field_72307_f;
            if (hit.field_72308_g != null && hit.field_72308_g instanceof EntityLivingBase) {
                if (hit.field_72308_g instanceof EntityPlayer && FMLCommonHandler.instance().getSide() == Side.SERVER && !MinecraftServer.func_71276_C().func_71219_W()) {
                    return;
                }
                DamageSource damageInfo = this.getDamageSource(item, player);
                float damage = this.getWeaponScaledDamage(item);
                EntityLivingBase el = (EntityLivingBase)hit.field_72308_g;
                double motionX = el.field_70159_w;
                double motionY = el.field_70181_x;
                double moutionZ = el.field_70179_y;
                if (damage > 0.0f) {
                    el.func_70097_a(damageInfo, damage);
                    el.field_70159_w = motionX;
                    el.field_70181_x = motionY;
                    el.field_70179_y = moutionZ;
                }
                el.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.GetSleepTime(item), 100));
                el.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.GetSleepTime(item), 100));
                el.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, this.GetSleepTime(item), -10));
                if (WeaponHelper.hasStat(4, item) && Phaser.isKillMode(item)) {
                    el.func_70015_d(MathHelper.round((double)(WeaponHelper.getStatMultiply(4, item) * (double)item.func_77978_p().func_74771_c("power"))));
                } else if (WeaponHelper.hasStat(8, item)) {
                    el.func_70691_i((float)(WeaponHelper.getStatMultiply(8, item) * (double)item.func_77978_p().func_74771_c("power")));
                }
            } else if (WeaponHelper.hasStat(4, item) && player.field_70170_p.func_147439_a(x = hit.field_72311_b, y = hit.field_72312_c, z = hit.field_72309_d).isFlammable((IBlockAccess)player.field_70170_p, x, y, z, ForgeDirection.getOrientation((int)hit.field_72310_e))) {
                if (hit.field_72310_e == 0) {
                    --y;
                }
                if (hit.field_72310_e == 1) {
                    ++y;
                }
                if (hit.field_72310_e == 2) {
                    --z;
                }
                if (hit.field_72310_e == 3) {
                    ++z;
                }
                if (hit.field_72310_e == 4) {
                    --x;
                }
                if (hit.field_72310_e == 5) {
                    ++x;
                }
                if (player.func_82247_a(x, y, z, hit.field_72310_e, item) && player.field_70170_p.func_147437_c(x, y, z)) {
                    player.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                }
            }
            if (Phaser.isKillMode(item) && WeaponHelper.hasStat(6, item)) {
                w.func_72876_a((Entity)player, hitVector.field_72450_a, hitVector.field_72448_b, hitVector.field_72449_c, (float)WeaponHelper.getStatMultiply(6, item) * (float)item.func_77978_p().func_74771_c("power") - 3.0f, true);
            }
        }
    }

    public Vec3 getPlayerLook(EntityPlayer player, ItemStack weapon) {
        Vec3 dir = player.func_70040_Z();
        Vec3 rot = this.getBeamRotation(weapon, player.field_70170_p);
        dir.func_72440_a((float)rot.field_72450_a);
        dir.func_72442_b((float)rot.field_72448_b);
        dir.func_72446_c((float)rot.field_72449_c);
        return dir;
    }

    public Vec3 getBeamRotation(ItemStack weapon, World world) {
        float accuracy = this.getHeat(weapon) / this.getMaxHeat(weapon);
        double rotationY = (float)Math.toRadians(5.0) * MOEasing.Quart.easeIn(accuracy, 0.0f, 1.0f, 1.0f);
        return Vec3.func_72443_a((double)0.0, (double)rotationY, (double)0.0);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        this.TagCompountCheck(item);
        if (!player.func_70093_af()) {
            if (this.canFire(item, world)) {
                player.func_71008_a(item, this.func_77626_a(item));
            }
            if (this.needsRecharge(item)) {
                this.chargeFromEnergyPack(item, player);
            }
            return item;
        }
        this.SwitchModes(world, player, item);
        return item;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer player) {
        return itemStack;
    }

    public void onUsingTick(ItemStack itemStack, EntityPlayer player, int count) {
        if (this.canFire(itemStack, player.field_70170_p)) {
            this.DrainEnergy(itemStack, 1, false);
            int powerLevelMultiply = (this.getPowerLevel(itemStack) + 1) / 6;
            float newHeat = (this.getHeat(itemStack) + 1.0f) * (1.1f + 0.05f * (float)powerLevelMultiply);
            this.setHeat(itemStack, newHeat);
            this.ManageShooting(itemStack, player.field_70170_p, player);
            this.manageOverheat(itemStack, player.field_70170_p, player);
        } else {
            player.func_71034_by();
        }
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int count) {
    }

    private void SwitchModes(World world, EntityPlayer player, ItemStack item) {
        this.TagCompountCheck(item);
        SoundHandler.PlaySoundAt(world, "phaser_switch_mode", (Entity)player);
        byte level = this.getPowerLevel(item);
        level = (byte)(level + 1);
        if (level >= 6) {
            level = 0;
        }
        this.setPowerLevel(item, level);
    }

    @Override
    public float getWeaponBaseDamage(ItemStack item) {
        float damage = 0.0f;
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        if (level >= 3) {
            damage = (float)Math.pow(2.5, level - 2);
        }
        return damage;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, 1, true);
    }

    private int GetSleepTime(ItemStack item) {
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        if (level < 3) {
            return (int)(Math.pow(level + 1, 5.0) * this.sleepTimeMultipy(item));
        }
        return 0;
    }

    private double sleepTimeMultipy(ItemStack phaser) {
        return WeaponHelper.getStatMultiply(0, phaser);
    }

    @Override
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 4: {
                return new Vector2f(200.0f, 45.0f);
            }
        }
        return new Vector2f(0.0f, 0.0f);
    }

    @Override
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 85.0f);
            }
            case 1: {
                return new Vector2f(100.0f, 80.0f);
            }
            case 2: {
                return new Vector2f(85.0f, 100.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spawnParticle(MovingObjectPosition hit, ItemStack weapon, World world) {
        Block b = world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        if (hit.field_72308_g != null && hit.field_72308_g instanceof EntityLivingBase) {
            if (WeaponHelper.hasStat(8, weapon)) {
                world.func_72869_a("happyVillager", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
                return;
            }
            if (WeaponHelper.hasStat(4, weapon)) {
                if (Phaser.isKillMode(weapon)) {
                    world.func_72869_a("flame", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
                    return;
                }
            }
            if (Phaser.isKillMode(weapon)) {
                world.func_72869_a("reddust", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
                return;
            }
            world.func_72869_a("magicCrit", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
            return;
        }
        if (b == null) return;
        if (b == Blocks.field_150350_a) return;
        if (WeaponHelper.hasStat(4, weapon)) {
            if (Phaser.isKillMode(weapon)) {
                world.func_72869_a("flame", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
        world.func_72869_a("smoke", hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return slot != 3;
    }

    @Override
    public boolean onLeftClick(ItemStack weapon, EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityPlayer entityPlayer, boolean zoomed, int seed, int latency, Vec3 position, Vec3 dir) {
        return false;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    public int getShootCooldown() {
        return 0;
    }

    public byte getPowerLevel(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            return weapon.func_77978_p().func_74771_c("power");
        }
        return 0;
    }

    public void setPowerLevel(ItemStack weapon, byte level) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_74774_a("power", level);
        }
    }
}

