/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.includes;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import java.util.List;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class MOItemEnergyContainer
extends MOBaseItem
implements IEnergyContainerItem {
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public MOItemEnergyContainer(String name) {
        this(name, 32000);
    }

    public MOItemEnergyContainer(String name, int capacity) {
        this(name, capacity, capacity, capacity);
    }

    public MOItemEnergyContainer(String name, int capacity, int maxTransfer) {
        this(name, capacity, maxTransfer, maxTransfer);
    }

    public MOItemEnergyContainer(String name, int capacity, int maxReceive, int maxExtract) {
        super(name);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getMaxEnergyStored(stack) - this.getEnergyStored(stack);
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        this.TagCompountCheck(itemstack);
        infos.add(EnumChatFormatting.YELLOW + MOEnergyHelper.formatEnergy(this.getEnergyStored(itemstack), this.getMaxEnergyStored(itemstack)));
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public MOItemEnergyContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        this.TagCompountCheck(container);
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d != null && container.field_77990_d.func_74764_b("Energy")) {
            int energy = container.field_77990_d.func_74762_e("Energy");
            int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
            }
            return energyExtracted;
        }
        return 0;
    }

    protected void setEnergyStored(ItemStack container, int amount) {
        EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)amount);
    }

    public int getEnergyStored(ItemStack container) {
        this.TagCompountCheck(container);
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

