/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.includes;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class MOEnergyMatterBlockItem
extends ItemBlock {
    public MOEnergyMatterBlockItem(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infos, boolean p_77624_4_) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (MOStringHelper.hasTranslation(this.func_77658_a() + ".details")) {
                infos.add(EnumChatFormatting.GRAY + MOStringHelper.translateToLocal(this.func_77658_a() + ".details"));
            }
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b("Energy") && stack.func_77978_p().func_74764_b("MaxEnergy")) {
                    infos.add(EnumChatFormatting.YELLOW + MOEnergyHelper.formatEnergy(stack.func_77978_p().func_74762_e("Energy"), stack.func_77978_p().func_74762_e("MaxEnergy")));
                    if (stack.func_77978_p().func_74764_b("PowerSend") && stack.func_77978_p().func_74764_b("PowerReceive")) {
                        infos.add("Send/Receive: " + MOStringHelper.formatNUmber(stack.func_77978_p().func_74762_e("PowerSend")) + "/" + MOStringHelper.formatNUmber(stack.func_77978_p().func_74762_e("PowerReceive")) + " RF" + "/t");
                    }
                }
                if (stack.func_77978_p().func_74764_b("Matter") && stack.func_77978_p().func_74764_b("MaxMatter")) {
                    infos.add(EnumChatFormatting.BLUE + MatterHelper.formatMatter(stack.func_77978_p().func_74762_e("Matter"), stack.func_77978_p().func_74762_e("MaxMatter")));
                    if (stack.func_77978_p().func_74764_b("MatterSend") && stack.func_77978_p().func_74764_b("MatterReceive")) {
                        infos.add(EnumChatFormatting.DARK_BLUE + "Send/Receive: " + MOStringHelper.formatNUmber(stack.func_77978_p().func_74762_e("MatterSend")) + "/" + MOStringHelper.formatNUmber(stack.func_77978_p().func_74762_e("MatterReceive")) + " kM" + "/t");
                    }
                }
                this.showUpgrades(stack, player, infos);
            }
        } else {
            infos.add(MOStringHelper.MORE_INFO);
        }
    }

    public int getDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy") && stack.func_77978_p().func_74764_b("MaxEnergy")) {
            return stack.func_77978_p().func_74762_e("MaxEnergy") - stack.func_77978_p().func_74762_e("Energy") + 1;
        }
        return 0;
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getDamage(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MaxEnergy")) {
            return stack.func_77978_p().func_74762_e("MaxEnergy");
        }
        return 0;
    }

    private void showUpgrades(ItemStack itemStack, EntityPlayer player, List infos) {
        NBTTagList upgrades = itemStack.func_77978_p().func_150295_c("Upgrades", 10);
        if (upgrades.func_74745_c() > 0) {
            infos.add("");
            infos.add("Upgrades:");
            HashMap<UpgradeTypes, Double> upgradesMap = new HashMap<UpgradeTypes, Double>();
            for (int i = 0; i < upgrades.func_74745_c(); ++i) {
                ItemStack upgradeItem = ItemStack.func_77949_a((NBTTagCompound)upgrades.func_150305_b(i));
                if (upgradeItem == null || !MatterHelper.isUpgrade(upgradeItem)) continue;
                IUpgrade upgrade = (IUpgrade)upgradeItem.func_77973_b();
                Map<UpgradeTypes, Double> upgradeMap = upgrade.getUpgrades(upgradeItem);
                for (Map.Entry<UpgradeTypes, Double> entry : upgradeMap.entrySet()) {
                    if (upgradesMap.containsKey((Object)entry.getKey())) {
                        double previusValue = (Double)upgradesMap.get((Object)entry.getKey());
                        upgradesMap.put(entry.getKey(), previusValue * entry.getValue());
                        continue;
                    }
                    upgradesMap.put(entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry entry : upgradesMap.entrySet()) {
                infos.add("   " + MOStringHelper.toInfo((UpgradeTypes)((Object)entry.getKey()), (Double)entry.getValue()));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }
}

