/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.Reference;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class MatterContainer
extends MOBaseItem {
    IIcon centerFill;
    IIcon bottomFill;
    boolean isFull;

    public MatterContainer(String name, boolean isFull) {
        super(name);
        this.isFull = isFull;
        this.func_77625_d(8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mo:container");
        this.centerFill = iconRegister.func_94245_a("mo:container_center_fill");
        this.bottomFill = iconRegister.func_94245_a("mo:container_bottom_fill");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return this.isFull;
    }

    public int getRenderPasses(int metadata) {
        return this.isFull ? 3 : 1;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityPlayer, !this.isFull);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(entityPlayer, i, j, k)) {
                return itemStack;
            }
            if (!this.isFull) {
                if (!entityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemStack)) {
                    return itemStack;
                }
                Block block = world.func_147439_a(i, j, k);
                int l = world.func_72805_g(i, j, k);
                if (block == MatterOverdriveBlocks.blockMatterPlasma && l == 0) {
                    world.func_147468_f(i, j, k);
                    return this.darinFluid(itemStack, entityPlayer, MatterOverdriveItems.matterContainerFull);
                }
            } else {
                if (!this.isFull) {
                    return new ItemStack((Item)MatterOverdriveItems.matterContainer);
                }
                if (movingobjectposition.field_72310_e == 0) {
                    --j;
                }
                if (movingobjectposition.field_72310_e == 1) {
                    ++j;
                }
                if (movingobjectposition.field_72310_e == 2) {
                    --k;
                }
                if (movingobjectposition.field_72310_e == 3) {
                    ++k;
                }
                if (movingobjectposition.field_72310_e == 4) {
                    --i;
                }
                if (movingobjectposition.field_72310_e == 5) {
                    ++i;
                }
                if (!entityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (this.tryPlaceContainedLiquid(world, i, j, k) && !entityPlayer.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                    if (itemStack.field_77994_a > 1) {
                        if (!entityPlayer.field_71071_by.func_70441_a(new ItemStack((Item)MatterOverdriveItems.matterContainer))) {
                            entityPlayer.func_71019_a(new ItemStack((Item)MatterOverdriveItems.matterContainer), false);
                        }
                    } else if (itemStack.field_77994_a <= 0) {
                        return new ItemStack((Item)MatterOverdriveItems.matterContainer);
                    }
                }
            }
        }
        return itemStack;
    }

    private ItemStack darinFluid(ItemStack itemStack, EntityPlayer entityPlayer, Item item) {
        if (entityPlayer.field_71075_bZ.field_75098_d) {
            return itemStack;
        }
        if (--itemStack.field_77994_a <= 0) {
            return new ItemStack(item);
        }
        if (!entityPlayer.field_71071_by.func_70441_a(new ItemStack(item))) {
            entityPlayer.func_71019_a(new ItemStack(item, 1, 0), false);
        }
        return itemStack;
    }

    public boolean tryPlaceContainedLiquid(World world, int x, int y, int z) {
        if (!this.isFull) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z)) {
            return false;
        }
        if (!world.field_72995_K && !material.func_76224_d()) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, (Block)MatterOverdriveBlocks.blockMatterPlasma, 0, 3);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 1 && this.isFull) {
            return this.centerFill;
        }
        if (pass == 2 && this.isFull) {
            return this.bottomFill;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        if (pass == 1 && this.isFull) {
            return Reference.COLOR_MATTER.getColor();
        }
        if (pass == 2 && this.isFull) {
            return Reference.COLOR_YELLOW_STRIPES.getColor();
        }
        return super.func_82790_a(itemStack, pass);
    }
}

