/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public class ItemUpgrade
extends MOBaseItem
implements IUpgrade {
    public static final String[] subItemNames = new String[]{"base", "speed", "power", "failsafe", "range", "power_storage", "hyper_speed", "matter_storage"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemUpgrade(String name) {
        super(name);
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(MatterOverdrive.tabMatterOverdrive_upgrades);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        return damage != 0;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        Map<UpgradeTypes, Double> stats = this.getUpgrades(itemstack);
        for (Map.Entry<UpgradeTypes, Double> entry : stats.entrySet()) {
            infos.add(MOStringHelper.toInfo(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void register(String name) {
        super.register(name);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 0), (Object[])new Object[]{" R ", " C ", " T ", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), MatterOverdriveItems.tritanium_plate, Character.valueOf('C'), new ItemStack((Item)MatterOverdriveItems.isolinear_circuit, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 1), (Object[])new Object[]{" R ", "GUG", " E ", Character.valueOf('U'), this, Character.valueOf('G'), Items.field_151114_aO, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('E'), Items.field_151166_bC});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 2), (Object[])new Object[]{" B ", "RUR", " C ", Character.valueOf('U'), this, Character.valueOf('B'), MatterOverdriveItems.battery, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), Items.field_151128_bU});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 3), (Object[])new Object[]{" D ", "RUR", " G ", Character.valueOf('U'), this, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 4), (Object[])new Object[]{" E ", "RUR", " G ", Character.valueOf('U'), this, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 5), (Object[])new Object[]{" B ", "RUR", " B ", Character.valueOf('U'), this, Character.valueOf('B'), MatterOverdriveItems.hc_battery, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), Items.field_151043_k});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this, 1, 6), (Object[])new Object[]{MatterOverdriveItems.dilithium_ctystal, Items.field_151156_bN, new ItemStack((Item)this, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1, 7), (Object[])new Object[]{" R ", "MUM", " R ", Character.valueOf('U'), this, Character.valueOf('M'), MatterOverdriveItems.s_magnet, Character.valueOf('R'), Items.field_151137_ax});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < subItemNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        int j = MathHelper.func_76125_a((int)damage, (int)0, (int)(this.icons.length - 1));
        return this.icons[j];
    }

    public String func_77667_c(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(subItemNames.length - 1));
        return super.func_77658_a() + "." + subItemNames[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[subItemNames.length];
        for (int i = 0; i < subItemNames.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mo:" + this.func_77658_a().substring(5) + "_" + subItemNames[i]);
        }
        this.field_77791_bV = this.icons[0];
    }

    @Override
    public Map<UpgradeTypes, Double> getUpgrades(ItemStack itemStack) {
        HashMap<UpgradeTypes, Double> upgrades = new HashMap<UpgradeTypes, Double>();
        int damage = itemStack.func_77960_j();
        switch (damage) {
            case 1: {
                upgrades.put(UpgradeTypes.Speed, 0.75);
                upgrades.put(UpgradeTypes.PowerUsage, 1.25);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                break;
            }
            case 2: {
                upgrades.put(UpgradeTypes.Speed, 1.5);
                upgrades.put(UpgradeTypes.PowerUsage, 0.75);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                break;
            }
            case 3: {
                upgrades.put(UpgradeTypes.Fail, 0.5);
                upgrades.put(UpgradeTypes.Speed, 1.25);
                upgrades.put(UpgradeTypes.PowerUsage, 1.25);
                break;
            }
            case 4: {
                upgrades.put(UpgradeTypes.Range, 4.0);
                upgrades.put(UpgradeTypes.PowerUsage, 1.5);
                break;
            }
            case 5: {
                upgrades.put(UpgradeTypes.PowerStorage, 2.0);
                break;
            }
            case 6: {
                upgrades.put(UpgradeTypes.Speed, 0.15);
                upgrades.put(UpgradeTypes.PowerUsage, 2.0);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                break;
            }
            case 7: {
                upgrades.put(UpgradeTypes.MatterStorage, 2.0);
            }
        }
        return upgrades;
    }
}

