/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.guide.GuideCategory;
import matteroverdrive.guide.GuideElementDetails;
import matteroverdrive.guide.GuideElementImage;
import matteroverdrive.guide.GuideElementPreview;
import matteroverdrive.guide.GuideElementRecipe;
import matteroverdrive.guide.GuideElementText;
import matteroverdrive.guide.GuideElementTitle;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MOGuideEntryBlock;
import matteroverdrive.guide.MOGuideEntryItem;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.guide.infograms.InfogramCreates;
import matteroverdrive.guide.infograms.InfogramDepth;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class MatterOverdriveGuides {
    public static GuideCategory androidCategory;
    public static GuideCategory weaponsCategory;
    public static GuideCategory generalCategory;

    public static void registerGuideElements(FMLInitializationEvent event) {
        MatterOverdriveGuide.registerGuideElementHandler("text", GuideElementText.class);
        MatterOverdriveGuide.registerGuideElementHandler("depth", InfogramDepth.class);
        MatterOverdriveGuide.registerGuideElementHandler("creates", InfogramCreates.class);
        MatterOverdriveGuide.registerGuideElementHandler("recipe", GuideElementRecipe.class);
        MatterOverdriveGuide.registerGuideElementHandler("title", GuideElementTitle.class);
        MatterOverdriveGuide.registerGuideElementHandler("image", GuideElementImage.class);
        MatterOverdriveGuide.registerGuideElementHandler("preview", GuideElementPreview.class);
        MatterOverdriveGuide.registerGuideElementHandler("details", GuideElementDetails.class);
    }

    public static void registerGuides(FMLPostInitializationEvent event) {
        generalCategory = new GuideCategory("general").setHoloIcon("home_icon");
        MatterOverdriveGuide.registerCategory(generalCategory);
        weaponsCategory = new GuideCategory("weapons").setHoloIcon("ammo");
        MatterOverdriveGuide.registerCategory(weaponsCategory);
        androidCategory = new GuideCategory("android").setHoloIcon("android_slot_arms");
        MatterOverdriveGuide.registerCategory(androidCategory);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.dilithium_ore).setGroup("ore"), 3, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.tritaniumOre).setGroup("ore"), 4, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.replicator).setGroup("machines"), 0, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.decomposer).setGroup("machines"), 1, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.recycler).setGroup("machines"), 0, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.matter_analyzer).setGroup("machines"), 1, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.pattern_storage).setGroup("machines"), 0, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.pattern_monitor).setGroup("machines"), 1, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.transporter).setGroup("machines"), 0, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.holoSign).setGroup("machines"), 1, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("fusion_reactor", new ItemStack[0]).setStackIcons(new ItemStack((Block)MatterOverdriveBlocks.fusion_reactor_controller), new ItemStack((Block)MatterOverdriveBlocks.fusion_reactor_coil), new ItemStack((Block)MatterOverdriveBlocks.forceGlass)).setGroup("power"), 3, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.gravitational_anomaly).setGroup("power"), 4, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.solar_panel).setGroup("power"), 3, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("batteries", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdriveItems.battery), new ItemStack((Item)MatterOverdriveItems.hc_battery)).setGroup("power"), 4, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_transport", new ItemStack[0]).setStackIcons(MatterOverdriveBlocks.heavy_matter_pipe).setGroup("matter"), 6, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_fail", new ItemStack[0]).setStackIcons(MatterOverdriveItems.matter_dust).setGroup("matter"), 7, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_plasma", new ItemStack((Item)MatterOverdriveItems.matterContainerFull)).setGroup("matter"), 6, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdriveItems.matter_scanner).setGroup("matter"), 7, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdriveItems.pattern_drive).setGroup("matter"), 6, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.network_pipe).setGroup("matter_network"), 6, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.network_switch).setGroup("matter_network"), 7, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdriveItems.networkFlashDrive).setGroup("matter_network"), 6, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.network_router).setGroup("matter_network"), 7, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem((Item)MatterOverdriveItems.spacetime_equalizer).setGroup("items"), 0, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdriveItems.security_protocol).setGroup("items"), 1, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("upgrades", new ItemStack[0]).setStackIcons(MatterOverdriveItems.item_upgrade).setGroup("items"), 2, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("drinks", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdriveItems.romulan_ale), new ItemStack((Item)MatterOverdriveItems.earl_gray_tea)).setGroup("items"), 3, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("food", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdriveItems.emergency_ration)).setGroup("items"), 4, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdriveItems.wrench).setGroup("items"), 0, 6);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdriveItems.phaser).setGroup("weapons"), 4, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdriveItems.phaserRifle).setGroup("weapons"), 5, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdriveItems.energyPack).setGroup("parts"), 1, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("weapon.modules.barrels", new ItemStack[0]).setStackIcons(MatterOverdriveItems.weapon_module_barrel).setGroup("parts"), 2, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("weapon.modules.colors", new ItemStack[0]).setStackIcons(MatterOverdriveItems.weapon_module_color).setGroup("parts"), 1, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.weapon_station).setGroup("machines"), 4, 2);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntry("android.pills", new ItemStack[0]).setStackIcons((Item)MatterOverdriveItems.androidPill).setGroup("items"), 5, 1);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntry("android.parts", new ItemStack[0]).setStackIcons(MatterOverdriveItems.androidParts).setGroup("items"), 5, 2);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.androidStation).setGroup("machines"), 2, 2);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntryBlock(MatterOverdriveBlocks.chargingStation).setGroup("machines"), 3, 2);
    }

    private static void addEntry(GuideCategory category, MOGuideEntry entry, int x, int y) {
        int paddingTop = 16;
        int paddingLeft = 18;
        category.addEntry(entry);
        entry.setGuiPos(paddingLeft + x * 28, paddingTop + y * 28);
        entry.setId(MatterOverdriveGuide.getNextFreeID());
        MatterOverdriveGuide.registerEntry(entry);
    }
}

