/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.EntityFailedChicken;
import matteroverdrive.entity.EntityFailedCow;
import matteroverdrive.entity.EntityFailedPig;
import matteroverdrive.entity.EntityFailedSheep;
import matteroverdrive.entity.EntityRogueAndroid;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.weapon.PhaserFire;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.village.TradeHandlerMadScientist;
import matteroverdrive.handler.village.VillageCreatationMadScientist;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class MatterOverdriveEntities {
    public static EntityRogueAndroid rogueandroid;

    public static void init(FMLPreInitializationEvent event, ConfigurationHandler configurationHandler) {
        rogueandroid = new EntityRogueAndroid();
        configurationHandler.subscribe(rogueandroid);
    }

    public static void register(FMLPostInitializationEvent event) {
        MatterOverdrive.configHandler.config.load();
        MatterOverdriveEntities.addEntity(EntityFailedPig.class, "failed_pig", 15771042, 0x33CC33);
        MatterOverdriveEntities.addEntity(EntityFailedCow.class, "failed_cow", 4470310, 0x33CC33);
        MatterOverdriveEntities.addEntity(EntityFailedChicken.class, "failed_chicken", 0xA1A1A1, 0x33CC33);
        MatterOverdriveEntities.addEntity(EntityFailedSheep.class, "failed_sheep", 0xE7E7E7, 0x33CC33);
        MatterOverdriveEntities.addEntity(EntityVillagerMadScientist.class, "mad_scientist", 0xFFFFFF, 0);
        VillagerRegistry.instance().registerVillageTradeHandler(666, (VillagerRegistry.IVillageTradeHandler)new TradeHandlerMadScientist());
        VillageCreatationMadScientist creatationMadScientist = new VillageCreatationMadScientist();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)creatationMadScientist);
        rogueandroid.registerEntity();
        int phaserFireID = MatterOverdriveEntities.registerEntityGlobalIDSafe(PhaserFire.class, "phaser_fire");
        EntityRegistry.registerGlobalEntityID(PhaserFire.class, (String)"phaser_fire", (int)phaserFireID);
        MatterOverdrive.configHandler.save();
    }

    public static void addViligger(int id, String texture, VillagerRegistry.IVillageTradeHandler tradeHandler) {
        VillagerRegistry.instance().registerVillagerId(id);
        VillagerRegistry.instance().registerVillagerSkin(id, new ResourceLocation("mo:textures/entities/" + texture));
    }

    public static int addEntity(Class<? extends Entity> enityClass, String name, int mainColor, int spotsColor) {
        int id = MatterOverdriveEntities.registerEntityGlobalIDSafe(enityClass, name);
        EntityRegistry.registerModEntity(enityClass, (String)name, (int)id, (Object)MatterOverdrive.instance, (int)64, (int)1, (boolean)true);
        MatterOverdriveEntities.createEgg(id, mainColor, spotsColor);
        return id;
    }

    public static void createEgg(int id, int solidColor, int spotColor) {
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, solidColor, spotColor));
    }

    public static int registerEntityGlobalIDSafe(Class<? extends Entity> entityClass, String name) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        if (MatterOverdrive.configHandler.config.hasKey("entities", MatterOverdriveEntities.getEntityConfigKey(name))) {
            id = MatterOverdrive.configHandler.getInt(MatterOverdriveEntities.getEntityConfigKey(name), "entities", 171);
        }
        while (id < 256) {
            try {
                EntityRegistry.registerGlobalEntityID(entityClass, (String)name, (int)id);
                break;
            }
            catch (Exception e) {
                if (++id != 256) continue;
                throw new RuntimeException("Could not find a free Entity ID for: " + entityClass);
            }
        }
        MatterOverdrive.configHandler.setInt(MatterOverdriveEntities.getEntityConfigKey(name), "entities", id);
        return id;
    }

    private static String getEntityConfigKey(String name) {
        return "entity." + name + ".id";
    }
}

