/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import matteroverdrive.api.network.IMatterNetworkHandler;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import org.apache.logging.log4j.Level;

public class MatterNetworkTickHandler
implements IConfigSubscriber {
    private int max_broadcasts;
    int lastID = 0;

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER) {
            int broadcastCount = 0;
            List tiles = event.world.field_147482_g;
            for (int i = this.lastID; i < tiles.size(); ++i) {
                if (!(tiles.get(i) instanceof IMatterNetworkHandler)) continue;
                try {
                    broadcastCount += ((IMatterNetworkHandler)tiles.get(i)).onNetworkTick(event.world, event.phase);
                }
                catch (Exception e) {
                    MOLog.log(Level.FATAL, e, "There was a problem while ticking MatterNetworkHandler %s", tiles.get(i));
                }
                if (broadcastCount < this.max_broadcasts) continue;
                return;
            }
            this.lastID = 0;
        }
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.max_broadcasts = config.getInt("max broadcasts per tick", "matter network", 128, "The maximum amount of network packet broadcasts per tick.");
    }
}

