/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EntityHandler {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && AndroidPlayer.get((EntityPlayer)event.entity) == null) {
            AndroidPlayer.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            AndroidPlayer.onEntityFall(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            AndroidPlayer.get((EntityPlayer)event.entity).sync(-1);
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving)) != null) {
            androidPlayer.onEntityJump(event);
            if (androidPlayer.isAndroid()) {
                for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                    int unlockedLevel = androidPlayer.getUnlockedLevel(stat);
                    if (unlockedLevel <= 0 || !stat.isEnabled(androidPlayer, unlockedLevel)) continue;
                    stat.onLivingEvent(androidPlayer, unlockedLevel, (LivingEvent)event);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        AndroidPlayer.get(event.entityPlayer).copy(AndroidPlayer.get(event.original));
        AndroidPlayer.get(event.entityPlayer).sync(-1);
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving)) != null && androidPlayer.isAndroid()) {
            for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                int unlockedLevel = androidPlayer.getUnlockedLevel(stat);
                if (unlockedLevel <= 0 || !stat.isEnabled(androidPlayer, unlockedLevel)) continue;
                stat.onLivingEvent(androidPlayer, unlockedLevel, (LivingEvent)event);
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)event.entityLiving);
            if (androidPlayer.isAndroid()) {
                for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                    int unlockedLevel = androidPlayer.getUnlockedLevel(stat);
                    if (unlockedLevel <= 0 || !stat.isEnabled(androidPlayer, unlockedLevel)) continue;
                    stat.onLivingEvent(androidPlayer, unlockedLevel, (LivingEvent)event);
                }
            }
            androidPlayer.onEntityHurt(event);
        }
    }
}

